/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.clunits;

import com.sun.speech.freetts.cart.CART;
import com.sun.speech.freetts.cart.CARTImpl;
import com.sun.speech.freetts.clunits.UnitType;
import com.sun.speech.freetts.relp.SampleInfo;
import com.sun.speech.freetts.relp.SampleSet;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ClusterUnitDatabase {
    static final int CLUNIT_NONE = 65535;
    private DatabaseClusterUnit[] units;
    private UnitType[] unitTypes;
    private SampleSet sts;
    private SampleSet mcep;
    private int continuityWeight;
    private int optimalCoupling;
    private int extendSelections;
    private int joinMethod;
    private int[] joinWeights;
    private int joinWeightShift;
    private Map cartMap = new HashMap();
    private CART defaultCart = null;
    private transient List unitList;
    private transient int lineCount;
    private transient List unitTypesList;
    private static final int MAGIC = -255144934;
    private static final int VERSION = 4096;

    ClusterUnitDatabase(URL url, boolean isBinary) throws IOException {
        BulkTimer.LOAD.start("ClusterUnitDatabase");
        InputStream is = Utilities.getInputStream(url);
        if (isBinary) {
            this.loadBinary(is);
        } else {
            this.loadText(is);
        }
        is.close();
        BulkTimer.LOAD.stop("ClusterUnitDatabase");
    }

    int getStart(int unitEntry) {
        return this.units[unitEntry].start;
    }

    int getEnd(int unitEntry) {
        return this.units[unitEntry].end;
    }

    int getPhone(int unitEntry) {
        return this.units[unitEntry].phone;
    }

    CART getTree(String unitType) {
        CART cart = (CART)this.cartMap.get(unitType);
        if (cart == null) {
            System.err.println("ClusterUnitDatabase: can't find tree for " + unitType);
            return this.defaultCart;
        }
        return cart;
    }

    int getUnitTypeIndex(String name) {
        int start = 0;
        int end = this.unitTypes.length;
        while (start < end) {
            int mid = (start + end) / 2;
            int c = this.unitTypes[mid].getName().compareTo(name);
            if (c == 0) {
                return mid;
            }
            if (c > 0) {
                end = mid;
                continue;
            }
            start = mid + 1;
        }
        return -1;
    }

    int getUnitIndex(String unitType, int instance) {
        int i = this.getUnitTypeIndex(unitType);
        if (i == -1) {
            this.error("getUnitIndex: can't find unit type " + unitType);
            i = 0;
        }
        if (instance >= this.unitTypes[i].getCount()) {
            this.error("getUnitIndex: can't find instance " + instance + " of " + unitType);
            instance = 0;
        }
        return this.unitTypes[i].getStart() + instance;
    }

    int getUnitIndexName(String name) {
        int lastIndex = name.lastIndexOf(95);
        if (lastIndex == -1) {
            this.error("getUnitIndexName: bad unit name " + name);
            return -1;
        }
        int index = Integer.parseInt(name.substring(lastIndex + 1));
        String type = name.substring(0, lastIndex);
        return this.getUnitIndex(type, index);
    }

    int getExtendSelections() {
        return this.extendSelections;
    }

    int getNextUnit(int which) {
        return this.units[which].next;
    }

    int getPrevUnit(int which) {
        return this.units[which].prev;
    }

    boolean isUnitTypeEqual(int unitA, int unitB) {
        return this.units[unitA].type == this.units[unitB].type;
    }

    int getOptimalCoupling() {
        return this.optimalCoupling;
    }

    int getContinuityWeight() {
        return this.continuityWeight;
    }

    int[] getJoinWeights() {
        return this.joinWeights;
    }

    DatabaseClusterUnit getUnit(String unitName) {
        return null;
    }

    DatabaseClusterUnit getUnit(int which) {
        return this.units[which];
    }

    String getName() {
        return "ClusterUnitDatabase";
    }

    SampleInfo getSampleInfo() {
        return this.sts.getSampleInfo();
    }

    SampleSet getSts() {
        return this.sts;
    }

    SampleSet getMcep() {
        return this.mcep;
    }

    int getJoinWeightShift() {
        return this.joinWeightShift;
    }

    private int calcJoinWeightShift(int[] joinWeights) {
        int first = joinWeights[0];
        for (int i = 1; i < joinWeights.length; ++i) {
            if (joinWeights[i] == first) continue;
            return 0;
        }
        int divisor = 65536 / first;
        if (divisor == 2) {
            return 1;
        }
        if (divisor == 4) {
            return 2;
        }
        return 0;
    }

    private void loadText(InputStream is) {
        this.unitList = new ArrayList();
        this.unitTypesList = new ArrayList();
        if (is == null) {
            throw new Error("Can't load cluster db file.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line = reader.readLine();
            ++this.lineCount;
            while (line != null) {
                if (!line.startsWith("***")) {
                    this.parseAndAdd(line, reader);
                }
                line = reader.readLine();
            }
            reader.close();
            this.units = new DatabaseClusterUnit[this.unitList.size()];
            this.units = this.unitList.toArray(this.units);
            this.unitList = null;
            this.unitTypes = new UnitType[this.unitTypesList.size()];
            this.unitTypes = this.unitTypesList.toArray(this.unitTypes);
            this.unitTypesList = null;
        }
        catch (IOException e) {
            throw new Error(e.getMessage() + " at line " + this.lineCount);
        }
    }

    private void parseAndAdd(String line, BufferedReader reader) throws IOException {
        block16: {
            try {
                StringTokenizer tokenizer = new StringTokenizer(line, " ");
                String tag = tokenizer.nextToken();
                if (tag.equals("CONTINUITY_WEIGHT")) {
                    this.continuityWeight = Integer.parseInt(tokenizer.nextToken());
                    break block16;
                }
                if (tag.equals("OPTIMAL_COUPLING")) {
                    this.optimalCoupling = Integer.parseInt(tokenizer.nextToken());
                    break block16;
                }
                if (tag.equals("EXTEND_SELECTIONS")) {
                    this.extendSelections = Integer.parseInt(tokenizer.nextToken());
                    break block16;
                }
                if (tag.equals("JOIN_METHOD")) {
                    this.joinMethod = Integer.parseInt(tokenizer.nextToken());
                    break block16;
                }
                if (tag.equals("JOIN_WEIGHTS")) {
                    int numWeights = Integer.parseInt(tokenizer.nextToken());
                    this.joinWeights = new int[numWeights];
                    for (int i = 0; i < numWeights; ++i) {
                        this.joinWeights[i] = Integer.parseInt(tokenizer.nextToken());
                    }
                    this.joinWeightShift = this.calcJoinWeightShift(this.joinWeights);
                    break block16;
                }
                if (tag.equals("STS")) {
                    String name = tokenizer.nextToken();
                    if (name.equals("STS")) {
                        this.sts = new SampleSet(tokenizer, reader);
                    } else {
                        this.mcep = new SampleSet(tokenizer, reader);
                    }
                    break block16;
                }
                if (tag.equals("UNITS")) {
                    int type = Integer.parseInt(tokenizer.nextToken());
                    int phone = Integer.parseInt(tokenizer.nextToken());
                    int start = Integer.parseInt(tokenizer.nextToken());
                    int end = Integer.parseInt(tokenizer.nextToken());
                    int prev = Integer.parseInt(tokenizer.nextToken());
                    int next = Integer.parseInt(tokenizer.nextToken());
                    DatabaseClusterUnit unit = new DatabaseClusterUnit(type, phone, start, end, prev, next);
                    this.unitList.add(unit);
                    break block16;
                }
                if (tag.equals("CART")) {
                    String name = tokenizer.nextToken();
                    int nodes = Integer.parseInt(tokenizer.nextToken());
                    CARTImpl cart = new CARTImpl(reader, nodes);
                    this.cartMap.put(name, cart);
                    if (this.defaultCart == null) {
                        this.defaultCart = cart;
                    }
                    break block16;
                }
                if (tag.equals("UNIT_TYPE")) {
                    String name = tokenizer.nextToken();
                    int start = Integer.parseInt(tokenizer.nextToken());
                    int count = Integer.parseInt(tokenizer.nextToken());
                    UnitType unitType = new UnitType(name, start, count);
                    this.unitTypesList.add(unitType);
                    break block16;
                }
                throw new Error("Unsupported tag " + tag + " in db line `" + line + "'");
            }
            catch (NoSuchElementException nse) {
                throw new Error("Error parsing db " + nse.getMessage());
            }
            catch (NumberFormatException nfe) {
                throw new Error("Error parsing numbers in db line `" + line + "':" + nfe.getMessage());
            }
        }
    }

    private void loadBinary(InputStream is) throws IOException {
        if (is instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)is;
            FileChannel fc = fis.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
            bb.load();
            this.loadBinary(bb);
            is.close();
        } else {
            this.loadBinary(new DataInputStream(is));
        }
    }

    private void loadBinary(ByteBuffer bb) throws IOException {
        if (bb.getInt() != -255144934) {
            throw new Error("Bad magic in db");
        }
        if (bb.getInt() != 4096) {
            throw new Error("Bad VERSION in db");
        }
        this.continuityWeight = bb.getInt();
        this.optimalCoupling = bb.getInt();
        this.extendSelections = bb.getInt();
        this.joinMethod = bb.getInt();
        this.joinWeightShift = bb.getInt();
        int weightLength = bb.getInt();
        this.joinWeights = new int[weightLength];
        for (int i = 0; i < this.joinWeights.length; ++i) {
            this.joinWeights[i] = bb.getInt();
        }
        int unitsLength = bb.getInt();
        this.units = new DatabaseClusterUnit[unitsLength];
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i] = new DatabaseClusterUnit(bb);
        }
        int unitTypesLength = bb.getInt();
        this.unitTypes = new UnitType[unitTypesLength];
        for (int i = 0; i < this.unitTypes.length; ++i) {
            this.unitTypes[i] = new UnitType(bb);
        }
        this.sts = new SampleSet(bb);
        this.mcep = new SampleSet(bb);
        int numCarts = bb.getInt();
        this.cartMap = new HashMap();
        for (int i = 0; i < numCarts; ++i) {
            String name = Utilities.getString(bb);
            CART cart = CARTImpl.loadBinary(bb);
            this.cartMap.put(name, cart);
            if (this.defaultCart != null) continue;
            this.defaultCart = cart;
        }
    }

    private void loadBinary(DataInputStream is) throws IOException {
        if (is.readInt() != -255144934) {
            throw new Error("Bad magic in db");
        }
        if (is.readInt() != 4096) {
            throw new Error("Bad VERSION in db");
        }
        this.continuityWeight = is.readInt();
        this.optimalCoupling = is.readInt();
        this.extendSelections = is.readInt();
        this.joinMethod = is.readInt();
        this.joinWeightShift = is.readInt();
        int weightLength = is.readInt();
        this.joinWeights = new int[weightLength];
        for (int i = 0; i < this.joinWeights.length; ++i) {
            this.joinWeights[i] = is.readInt();
        }
        int unitsLength = is.readInt();
        this.units = new DatabaseClusterUnit[unitsLength];
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i] = new DatabaseClusterUnit(is);
        }
        int unitTypesLength = is.readInt();
        this.unitTypes = new UnitType[unitTypesLength];
        for (int i = 0; i < this.unitTypes.length; ++i) {
            this.unitTypes[i] = new UnitType(is);
        }
        this.sts = new SampleSet(is);
        this.mcep = new SampleSet(is);
        int numCarts = is.readInt();
        this.cartMap = new HashMap();
        for (int i = 0; i < numCarts; ++i) {
            String name = Utilities.getString(is);
            CART cart = CARTImpl.loadBinary(is);
            this.cartMap.put(name, cart);
            if (this.defaultCart != null) continue;
            this.defaultCart = cart;
        }
    }

    void dumpBinary(String path) {
        try {
            int i;
            FileOutputStream fos = new FileOutputStream(path);
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(fos));
            os.writeInt(-255144934);
            os.writeInt(4096);
            os.writeInt(this.continuityWeight);
            os.writeInt(this.optimalCoupling);
            os.writeInt(this.extendSelections);
            os.writeInt(this.joinMethod);
            os.writeInt(this.joinWeightShift);
            os.writeInt(this.joinWeights.length);
            for (i = 0; i < this.joinWeights.length; ++i) {
                os.writeInt(this.joinWeights[i]);
            }
            os.writeInt(this.units.length);
            for (i = 0; i < this.units.length; ++i) {
                this.units[i].dumpBinary(os);
            }
            os.writeInt(this.unitTypes.length);
            for (i = 0; i < this.unitTypes.length; ++i) {
                this.unitTypes[i].dumpBinary(os);
            }
            this.sts.dumpBinary(os);
            this.mcep.dumpBinary(os);
            os.writeInt(this.cartMap.size());
            Iterator i2 = this.cartMap.keySet().iterator();
            while (i2.hasNext()) {
                String name = (String)i2.next();
                CART cart = (CART)this.cartMap.get(name);
                Utilities.outString(os, name);
                cart.dumpBinary(os);
            }
            os.close();
        }
        catch (FileNotFoundException fe) {
            throw new Error("Can't dump binary database " + fe.getMessage());
        }
        catch (IOException ioe) {
            throw new Error("Can't write binary database " + ioe.getMessage());
        }
    }

    public boolean compare(ClusterUnitDatabase other) {
        System.out.println("Warning: Compare not implemented yet");
        return false;
    }

    public static void main(String[] args) {
        boolean showTimes = false;
        String srcPath = ".";
        String destPath = ".";
        try {
            if (args.length > 0) {
                BulkTimer timer = new BulkTimer();
                timer.start();
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-src")) {
                        srcPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-dest")) {
                        destPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-generate_binary")) {
                        String nameArg;
                        String name = "clunits.txt";
                        if (i + 1 < args.length && !(nameArg = args[++i]).startsWith("-")) {
                            name = nameArg;
                        }
                        int suffixPos = name.lastIndexOf(".txt");
                        String binaryName = "clunits.bin";
                        if (suffixPos != -1) {
                            binaryName = name.substring(0, suffixPos) + ".bin";
                        }
                        System.out.println("Loading " + name);
                        timer.start("load_text");
                        ClusterUnitDatabase udb = new ClusterUnitDatabase(new URL("file:" + srcPath + "/" + name), false);
                        timer.stop("load_text");
                        System.out.println("Dumping " + binaryName);
                        timer.start("dump_binary");
                        udb.dumpBinary(destPath + "/" + binaryName);
                        timer.stop("dump_binary");
                        continue;
                    }
                    if (args[i].equals("-compare")) {
                        timer.start("load_text");
                        ClusterUnitDatabase udb = new ClusterUnitDatabase(new URL("file:./cmu_time_awb.txt"), false);
                        timer.stop("load_text");
                        timer.start("load_binary");
                        ClusterUnitDatabase budb = new ClusterUnitDatabase(new URL("file:./cmu_time_awb.bin"), true);
                        timer.stop("load_binary");
                        timer.start("compare");
                        if (udb.compare(budb)) {
                            System.out.println("other compare ok");
                        } else {
                            System.out.println("other compare different");
                        }
                        timer.stop("compare");
                        continue;
                    }
                    if (args[i].equals("-showtimes")) {
                        showTimes = true;
                        continue;
                    }
                    System.out.println("Unknown option " + args[i]);
                }
                timer.stop();
                if (showTimes) {
                    timer.show("ClusterUnitDatabase");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -src path");
                System.out.println("    -dest path");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showTimes");
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    private void error(String s) {
        System.out.println("ClusterUnitDatabase Error: " + s);
    }

    class DatabaseClusterUnit {
        int type;
        int phone;
        int start;
        int end;
        int prev;
        int next;

        DatabaseClusterUnit(int type, int phone, int start, int end, int prev, int next) {
            this.type = type;
            this.phone = phone;
            this.start = start;
            this.end = end;
            this.prev = prev;
            this.next = next;
        }

        DatabaseClusterUnit(ByteBuffer bb) throws IOException {
            this.type = bb.getInt();
            this.phone = bb.getInt();
            this.start = bb.getInt();
            this.end = bb.getInt();
            this.prev = bb.getInt();
            this.next = bb.getInt();
        }

        DatabaseClusterUnit(DataInputStream is) throws IOException {
            this.type = is.readInt();
            this.phone = is.readInt();
            this.start = is.readInt();
            this.end = is.readInt();
            this.prev = is.readInt();
            this.next = is.readInt();
        }

        String getName() {
            return ClusterUnitDatabase.this.unitTypes[this.type].getName();
        }

        void dumpBinary(DataOutputStream os) throws IOException {
            os.writeInt(this.type);
            os.writeInt(this.phone);
            os.writeInt(this.start);
            os.writeInt(this.end);
            os.writeInt(this.prev);
            os.writeInt(this.next);
        }
    }
}

