/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.xml;

import com.romraider.Settings;
import com.romraider.xml.DOMHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMSettingsUnmarshaller {
    public Settings unmarshallSettings(Node node) {
        Settings settings = new Settings();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("window")) {
                settings = this.unmarshallWindow(node2, settings);
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("files")) {
                settings = this.unmarshallFiles(node2, settings);
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("options")) {
                settings = this.unmarshallOptions(node2, settings);
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("tabledisplay")) {
                settings = this.unmarshallTableDisplay(node2, settings);
                continue;
            }
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("logger")) continue;
            settings = this.unmarshallLogger(node2, settings);
        }
        return settings;
    }

    private Settings unmarshallWindow(Node node, Settings settings) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("maximized")) {
                settings.setWindowMaximized(DOMHelper.unmarshallAttribute(node2, "value", false));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("size")) {
                settings.setWindowSize(new Dimension(DOMHelper.unmarshallAttribute(node2, "y", 600), DOMHelper.unmarshallAttribute(node2, "x", 800)));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("location")) {
                settings.setWindowLocation(new Point(DOMHelper.unmarshallAttribute(node2, "x", 0), DOMHelper.unmarshallAttribute(node2, "y", 0)));
                continue;
            }
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("splitpane")) continue;
            settings.setSplitPaneLocation(DOMHelper.unmarshallAttribute(node2, "location", 150));
        }
        return settings;
    }

    private Settings unmarshallFiles(Node node, Settings settings) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("ecudefinitionfile")) {
                settings.addEcuDefinitionFile(new File(DOMHelper.unmarshallAttribute(node2, "name", "ecu_defs.xml")));
                continue;
            }
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("image_dir")) continue;
            settings.setLastImageDir(new File(DOMHelper.unmarshallAttribute(node2, "path", "ecu_defs.xml")));
        }
        return settings;
    }

    private Settings unmarshallOptions(Node node, Settings settings) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("obsoletewarning")) {
                settings.setObsoleteWarning(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(node2, "value", "true")));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("debug")) {
                settings.setDebug(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(node2, "value", "true")));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("calcconflictwarning")) {
                settings.setCalcConflictWarning(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(node2, "value", "true")));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("userlevel")) {
                settings.setUserLevel(DOMHelper.unmarshallAttribute(node2, "value", 1));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("tableclickcount")) {
                settings.setTableClickCount(DOMHelper.unmarshallAttribute(node2, "value", 2));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("version")) {
                settings.setRecentVersion(DOMHelper.unmarshallAttribute(node2, "value", ""));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("savedebugtables")) {
                settings.setSaveDebugTables(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(node2, "value", "false")));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("displayhightables")) {
                settings.setDisplayHighTables(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(node2, "value", "false")));
                continue;
            }
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("valuelimitwarning")) continue;
            settings.setValueLimitWarning(Boolean.parseBoolean(DOMHelper.unmarshallAttribute(node2, "value", "true")));
        }
        return settings;
    }

    private Settings unmarshallTableDisplay(Node node, Settings settings) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("font")) {
                settings.setTableFont(new Font(DOMHelper.unmarshallAttribute(node2, "face", "Arial"), DOMHelper.unmarshallAttribute(node2, "decoration", 1), DOMHelper.unmarshallAttribute(node2, "size", 12)));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("cellsize")) {
                settings.setCellSize(new Dimension(DOMHelper.unmarshallAttribute(node2, "width", 42), DOMHelper.unmarshallAttribute(node2, "height", 18)));
                continue;
            }
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("colors")) continue;
            settings = this.unmarshallColors(node2, settings);
        }
        return settings;
    }

    private Settings unmarshallColors(Node node, Settings settings) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("max")) {
                settings.setMaxColor(this.unmarshallColor(node2));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("min")) {
                settings.setMinColor(this.unmarshallColor(node2));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("highlight")) {
                settings.setHighlightColor(this.unmarshallColor(node2));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("increaseborder")) {
                settings.setIncreaseBorder(this.unmarshallColor(node2));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("decreaseborder")) {
                settings.setDecreaseBorder(this.unmarshallColor(node2));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("axis")) {
                settings.setAxisColor(this.unmarshallColor(node2));
                continue;
            }
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("warning")) continue;
            settings.setWarningColor(this.unmarshallColor(node2));
        }
        return settings;
    }

    private Settings unmarshallLogger(Node node, Settings settings) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("serial")) {
                settings.setLoggerPortDefault(DOMHelper.unmarshallAttribute(node2, "port", ""));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("maximized")) {
                settings.setLoggerWindowMaximized(DOMHelper.unmarshallAttribute(node2, "value", false));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("size")) {
                settings.setLoggerWindowSize(new Dimension(DOMHelper.unmarshallAttribute(node2, "y", 600), DOMHelper.unmarshallAttribute(node2, "x", 1000)));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("location")) {
                settings.setLoggerWindowLocation(new Point(DOMHelper.unmarshallAttribute(node2, "x", 150), DOMHelper.unmarshallAttribute(node2, "y", 150)));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("tabs")) {
                settings.setLoggerSelectedTabIndex(DOMHelper.unmarshallAttribute(node2, "selected", 0));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("definition")) {
                settings.setLoggerDefinitionFilePath(DOMHelper.unmarshallAttribute(node2, "path", settings.getLoggerDefinitionFilePath()));
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equalsIgnoreCase("profile")) {
                settings.setLoggerProfileFilePath(DOMHelper.unmarshallAttribute(node2, "path", ""));
                continue;
            }
            if (node2.getNodeType() != 1 || !node2.getNodeName().equalsIgnoreCase("filelogging")) continue;
            settings.setLoggerOutputDirPath(DOMHelper.unmarshallAttribute(node2, "path", ""));
            settings.setFileLoggingControllerSwitchId(DOMHelper.unmarshallAttribute(node2, "switchid", settings.getFileLoggingControllerSwitchId()));
            settings.setFileLoggingControllerSwitchActive(DOMHelper.unmarshallAttribute(node2, "active", true));
            settings.setFileLoggingAbsoluteTimestamp(DOMHelper.unmarshallAttribute(node2, "absolutetimestamp", false));
        }
        return settings;
    }

    private Color unmarshallColor(Node node) {
        return new Color(DOMHelper.unmarshallAttribute(node, "r", 155), DOMHelper.unmarshallAttribute(node, "g", 155), DOMHelper.unmarshallAttribute(node, "b", 155));
    }
}

