/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

import com.romraider.Settings;
import com.romraider.swing.JProgressPane;
import com.romraider.util.SettingsManager;
import com.romraider.xml.DOMSettingsBuilder;
import com.romraider.xml.DOMSettingsUnmarshaller;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class SettingsManagerImpl
implements SettingsManager {
    private static final String SETTINGS_FILE = "./settings.xml";

    public Settings load() {
        try {
            InputSource inputSource = new InputSource(new FileInputStream(new File(SETTINGS_FILE)));
            DOMSettingsUnmarshaller dOMSettingsUnmarshaller = new DOMSettingsUnmarshaller();
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            Document document = dOMParser.getDocument();
            return dOMSettingsUnmarshaller.unmarshallSettings(document.getDocumentElement());
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Settings file not found.\nUsing default settings.", "Error Loading Settings", 1);
            return new Settings();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void save(Settings settings) {
        this.save(settings, new JProgressPane());
    }

    public void save(Settings settings, JProgressPane jProgressPane) {
        DOMSettingsBuilder dOMSettingsBuilder = new DOMSettingsBuilder();
        try {
            dOMSettingsBuilder.buildSettings(settings, new File(SETTINGS_FILE), jProgressPane, "0.5.2 Beta ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

