/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public final class RomServer {
    private static final Logger LOGGER = Logger.getLogger(RomServer.class);
    private static final String HOST = "localhost";
    private static final int PORT = 50001;

    public static boolean isRunning() {
        try {
            ServerSocket serverSocket = new ServerSocket(50001);
            serverSocket.close();
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String waitForRom() throws IOException {
        ServerSocket serverSocket = new ServerSocket(50001);
        try {
            String string = RomServer.waitForRom(serverSocket);
            return string;
        }
        finally {
            serverSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendRomToOpenInstance(String string) {
        try {
            Socket socket = new Socket(HOST, 50001);
            OutputStream outputStream = socket.getOutputStream();
            try {
                RomServer.write(outputStream, string);
            }
            finally {
                socket.close();
            }
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)"Error occurred", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        try {
            printWriter.println(string);
        }
        finally {
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String waitForRom(ServerSocket serverSocket) throws IOException {
        Socket socket = serverSocket.accept();
        try {
            String string = RomServer.getRom(socket);
            return string;
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRom(Socket socket) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        try {
            String string = bufferedReader.readLine();
            return string;
        }
        finally {
            bufferedReader.close();
        }
    }
}

