/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import ZoeloeSoft.projects.JFontChooser.JFontChooser;
import com.romraider.ECUEditor;
import com.romraider.Settings;
import com.romraider.util.FileAssociator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class SettingsForm
extends JFrame
implements MouseListener {
    private static final long serialVersionUID = 3910602424260147767L;
    Settings settings;
    ECUEditor parent;
    private JLabel axisColor;
    private JButton btnAddAssocs;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnChooseFont;
    private JButton btnOk;
    private JButton btnRemoveAssocs;
    private JCheckBox calcConflictWarning;
    private JTextField cellHeight;
    private JTextField cellWidth;
    private JCheckBox debug;
    private JLabel decreaseColor;
    private JCheckBox displayHighTables;
    private JCheckBox extensionBin;
    private JCheckBox extensionHex;
    private JLabel highlightColor;
    private JLabel increaseColor;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel lblAxis;
    private JLabel lblCellHeight;
    private JLabel lblCellWidth;
    private JLabel lblDecrease;
    private JLabel lblFont;
    private JLabel lblHighlight;
    private JLabel lblIncrease;
    private JLabel lblMax;
    private JLabel lblMin;
    private JLabel lblWarning;
    private JLabel maxColor;
    private JLabel minColor;
    private JCheckBox obsoleteWarning;
    private JButton reset;
    private JCheckBox saveDebugTables;
    private JComboBox tableClickCount;
    private JCheckBox valueLimitWarning;
    private JLabel warningColor;

    public SettingsForm(ECUEditor eCUEditor) {
        this.parent = eCUEditor;
        this.settings = eCUEditor.getSettings();
        this.initComponents();
        this.initSettings();
        this.maxColor.addMouseListener(this);
        this.minColor.addMouseListener(this);
        this.highlightColor.addMouseListener(this);
        this.axisColor.addMouseListener(this);
        this.increaseColor.addMouseListener(this);
        this.decreaseColor.addMouseListener(this);
        this.warningColor.addMouseListener(this);
        this.btnOk.addMouseListener(this);
        this.btnApply.addMouseListener(this);
        this.btnCancel.addMouseListener(this);
        this.btnChooseFont.addMouseListener(this);
        this.reset.addMouseListener(this);
        this.btnAddAssocs.addMouseListener(this);
        this.btnRemoveAssocs.addMouseListener(this);
        this.tableClickCount.setBackground(Color.WHITE);
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperties().getProperty("os.name"));
        if (!stringTokenizer.nextToken().equalsIgnoreCase("windows")) {
            this.btnAddAssocs.setEnabled(false);
            this.btnRemoveAssocs.setEnabled(false);
            this.extensionHex.setEnabled(false);
            this.extensionBin.setEnabled(false);
        }
    }

    private void initSettings() {
        this.obsoleteWarning.setSelected(this.settings.isObsoleteWarning());
        this.calcConflictWarning.setSelected(this.settings.isCalcConflictWarning());
        this.displayHighTables.setSelected(this.settings.isDisplayHighTables());
        this.saveDebugTables.setSelected(this.settings.isSaveDebugTables());
        this.debug.setSelected(this.settings.isDebug());
        this.maxColor.setBackground(this.settings.getMaxColor());
        this.minColor.setBackground(this.settings.getMinColor());
        this.highlightColor.setBackground(this.settings.getHighlightColor());
        this.axisColor.setBackground(this.settings.getAxisColor());
        this.increaseColor.setBackground(this.settings.getIncreaseBorder());
        this.decreaseColor.setBackground(this.settings.getDecreaseBorder());
        this.cellWidth.setText((int)this.settings.getCellSize().getWidth() + "");
        this.cellHeight.setText((int)this.settings.getCellSize().getHeight() + "");
        this.btnChooseFont.setFont(this.settings.getTableFont());
        this.btnChooseFont.setText(this.settings.getTableFont().getFontName());
        if (this.settings.getTableClickCount() == 1) {
            this.tableClickCount.setSelectedIndex(0);
        } else {
            this.tableClickCount.setSelectedIndex(1);
        }
        this.valueLimitWarning.setSelected(this.settings.isValueLimitWarning());
        this.warningColor.setBackground(this.settings.getWarningColor());
    }

    private void initComponents() {
        this.obsoleteWarning = new JCheckBox();
        this.calcConflictWarning = new JCheckBox();
        this.debug = new JCheckBox();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.btnApply = new JButton();
        this.reset = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblAxis = new JLabel();
        this.lblHighlight = new JLabel();
        this.lblMin = new JLabel();
        this.lblMax = new JLabel();
        this.maxColor = new JLabel();
        this.minColor = new JLabel();
        this.highlightColor = new JLabel();
        this.axisColor = new JLabel();
        this.warningColor = new JLabel();
        this.lblWarning = new JLabel();
        this.jPanel3 = new JPanel();
        this.lblIncrease = new JLabel();
        this.increaseColor = new JLabel();
        this.decreaseColor = new JLabel();
        this.lblDecrease = new JLabel();
        this.lblCellHeight = new JLabel();
        this.cellHeight = new JTextField();
        this.cellWidth = new JTextField();
        this.lblCellWidth = new JLabel();
        this.lblFont = new JLabel();
        this.btnChooseFont = new JButton();
        this.saveDebugTables = new JCheckBox();
        this.displayHighTables = new JCheckBox();
        this.valueLimitWarning = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.extensionHex = new JCheckBox();
        this.extensionBin = new JCheckBox();
        this.btnAddAssocs = new JButton();
        this.btnRemoveAssocs = new JButton();
        this.jLabel1 = new JLabel();
        this.tableClickCount = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("RomRaider Settings");
        this.setCursor(new Cursor(0));
        this.setFont(new Font("Tahoma", 0, 11));
        this.obsoleteWarning.setText("Warn me when opening out of date ECU image revision");
        this.obsoleteWarning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.obsoleteWarning.setMargin(new Insets(0, 0, 0, 0));
        this.calcConflictWarning.setText("Warn me when real and byte value calculations conflict");
        this.calcConflictWarning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.calcConflictWarning.setMargin(new Insets(0, 0, 0, 0));
        this.debug.setText("Debug mode");
        this.debug.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.debug.setEnabled(false);
        this.debug.setMargin(new Insets(0, 0, 0, 0));
        this.btnCancel.setMnemonic('C');
        this.btnCancel.setText("Cancel");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("OK");
        this.btnApply.setMnemonic('A');
        this.btnApply.setText("Apply");
        this.reset.setText("Restore Defaults");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Table Display"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Background"));
        this.lblAxis.setText("Axis Cell:");
        this.lblHighlight.setText("Highlighted Cell:");
        this.lblMin.setText("Minimum Value:");
        this.lblMax.setText("Maximum Value:");
        this.maxColor.setBackground(new Color(255, 0, 0));
        this.maxColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.maxColor.setOpaque(true);
        this.minColor.setBackground(new Color(255, 0, 0));
        this.minColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.minColor.setOpaque(true);
        this.highlightColor.setBackground(new Color(255, 0, 0));
        this.highlightColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.highlightColor.setOpaque(true);
        this.axisColor.setBackground(new Color(255, 0, 0));
        this.axisColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.axisColor.setOpaque(true);
        this.warningColor.setBackground(new Color(255, 0, 0));
        this.warningColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.warningColor.setOpaque(true);
        this.lblWarning.setText("Warning:");
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lblWarning).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(4, 4, 4).add((Component)this.lblMin)).add((Component)this.lblMax))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.maxColor, -2, 50, -2).addPreferredGap(0, 22, Short.MAX_VALUE).add((Component)this.lblHighlight).addPreferredGap(0).add((Component)this.highlightColor, -2, 50, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.minColor, -2, 50, -2).addPreferredGap(0, 55, Short.MAX_VALUE).add((Component)this.lblAxis).addPreferredGap(0).add((Component)this.axisColor, -2, 50, -2)).add((Component)this.warningColor, -2, 50, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblMax).add((Component)this.maxColor, -2, 15, -2).add((Component)this.highlightColor, -2, 15, -2).add((Component)this.lblHighlight)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblMin).add((Component)this.minColor, -2, 15, -2).add((Component)this.axisColor, -2, 15, -2).add((Component)this.lblAxis)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.warningColor, -2, 15, -2).add((Component)this.lblWarning))));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Cell Borders"));
        this.lblIncrease.setText("Increased:");
        this.increaseColor.setBackground(new Color(255, 0, 0));
        this.increaseColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.increaseColor.setOpaque(true);
        this.decreaseColor.setBackground(new Color(255, 0, 0));
        this.decreaseColor.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.decreaseColor.setOpaque(true);
        this.lblDecrease.setText("Decreased:");
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.lblIncrease).addPreferredGap(0).add((Component)this.increaseColor, -2, 50, -2).addPreferredGap(0, 59, Short.MAX_VALUE).add((Component)this.lblDecrease).addPreferredGap(0).add((Component)this.decreaseColor, -2, 50, -2).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.decreaseColor, -2, 15, -2).add((Component)this.lblDecrease).add((Component)this.lblIncrease).add((Component)this.increaseColor, -2, 15, -2)));
        this.lblCellHeight.setText("Cell Height:");
        this.lblCellWidth.setText("Cell Width:");
        this.lblFont.setText("Font:");
        this.btnChooseFont.setText("Choose");
        this.saveDebugTables.setText("Save changes made on tables in debug mode");
        this.saveDebugTables.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.saveDebugTables.setMargin(new Insets(0, 0, 0, 0));
        this.displayHighTables.setText("List tables that are above my userlevel");
        this.displayHighTables.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.displayHighTables.setMargin(new Insets(0, 0, 0, 0));
        this.valueLimitWarning.setText("Warn when values exceed limits");
        this.valueLimitWarning.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.valueLimitWarning.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("File Associations"));
        this.extensionHex.setText("HEX");
        this.extensionHex.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extensionHex.setMargin(new Insets(0, 0, 0, 0));
        this.extensionBin.setText("BIN");
        this.extensionBin.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.extensionBin.setMargin(new Insets(0, 0, 0, 0));
        this.btnAddAssocs.setText("Add Associations");
        this.btnRemoveAssocs.setText("Remove Associations");
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.extensionBin).add((Component)this.extensionHex)).addPreferredGap(0, 93, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createParallelGroup(1, false).add((Component)this.btnAddAssocs, -1, -1, Short.MAX_VALUE).add((Component)this.btnRemoveAssocs)).add(25, 25, 25)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.btnAddAssocs).add((Component)this.extensionHex)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.btnRemoveAssocs).add((Component)this.extensionBin))));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(2).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.saveDebugTables).add((Component)this.displayHighTables).add((Component)this.valueLimitWarning)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.lblCellHeight).add((Component)this.lblFont)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.btnChooseFont).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.cellHeight, -2, 50, -2).addPreferredGap(0, 42, Short.MAX_VALUE).add((Component)this.lblCellWidth).addPreferredGap(0).add((Component)this.cellWidth, -2, 50, -2))))).add(47, 47, 47)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).add(22, 22, 22).add((Component)this.saveDebugTables).addPreferredGap(0).add((Component)this.displayHighTables).addPreferredGap(0).add((Component)this.valueLimitWarning).add(27, 27, 27).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.lblCellWidth).add((Component)this.cellWidth, -2, -1, -2).add((Component)this.lblCellHeight).add((Component)this.cellHeight, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.lblFont).add((Component)this.btnChooseFont, -2, 18, -2))));
        this.jLabel1.setText("click to open tables");
        this.tableClickCount.setModel(new DefaultComboBoxModel<String>(new String[]{"Single", "Double"}));
        GroupLayout groupLayout5 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(2).add(1, (Component)this.jPanel1, 0, -1, Short.MAX_VALUE).add(1, (Component)this.calcConflictWarning).add(1, (Component)this.obsoleteWarning).add(1, (GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.tableClickCount, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel1)).add(1, (Component)this.debug).add(1, (GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.reset).addPreferredGap(0, 34, Short.MAX_VALUE).add((Component)this.btnApply).addPreferredGap(0).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancel))).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.tableClickCount, -2, 18, -2)).addPreferredGap(0).add((Component)this.obsoleteWarning).addPreferredGap(0).add((Component)this.calcConflictWarning).addPreferredGap(0).add((Component)this.debug).add(17, 17, 17).add((Component)this.jPanel1, -2, -1, -2).add(22, 22, 22).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.btnCancel).add((Component)this.btnApply).add((Component)this.reset).add((Component)this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.maxColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", this.settings.getMaxColor());
            if (color != null) {
                this.maxColor.setBackground(color);
            }
        } else if (mouseEvent.getSource() == this.minColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", this.settings.getMinColor());
            if (color != null) {
                this.minColor.setBackground(color);
            }
        } else if (mouseEvent.getSource() == this.highlightColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", this.settings.getHighlightColor());
            if (color != null) {
                this.highlightColor.setBackground(color);
            }
        } else if (mouseEvent.getSource() == this.axisColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", this.settings.getAxisColor());
            if (color != null) {
                this.axisColor.setBackground(color);
            }
        } else if (mouseEvent.getSource() == this.increaseColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", this.settings.getIncreaseBorder());
            if (color != null) {
                this.increaseColor.setBackground(color);
            }
        } else if (mouseEvent.getSource() == this.decreaseColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Background Color", this.settings.getDecreaseBorder());
            if (color != null) {
                this.decreaseColor.setBackground(color);
            }
        } else if (mouseEvent.getSource() == this.warningColor) {
            Color color = JColorChooser.showDialog(this.getContentPane(), "Warning Color", this.settings.getWarningColor());
            if (color != null) {
                this.warningColor.setBackground(color);
            }
        } else if (mouseEvent.getSource() == this.btnApply) {
            this.applySettings();
        } else if (mouseEvent.getSource() == this.btnOk) {
            this.applySettings();
            this.dispose();
        } else if (mouseEvent.getSource() == this.btnCancel) {
            this.dispose();
        } else if (mouseEvent.getSource() == this.btnChooseFont) {
            JFontChooser jFontChooser = new JFontChooser((Frame)this);
            jFontChooser.setLocationRelativeTo((Component)this);
            if (jFontChooser.showDialog(this.settings.getTableFont()) == JFontChooser.OK_OPTION) {
                this.btnChooseFont.setFont(jFontChooser.getFont());
                this.btnChooseFont.setText(jFontChooser.getFont().getFontName());
            }
        } else if (mouseEvent.getSource() == this.reset) {
            this.settings = new Settings();
            this.initSettings();
        } else if (mouseEvent.getSource() == this.btnAddAssocs) {
            try {
                if (this.extensionHex.isSelected()) {
                    FileAssociator.addAssociation("HEX", new File(".").getCanonicalPath() + File.separator + "RomRaider" + ".exe", "ECU Image");
                }
                if (this.extensionBin.isSelected()) {
                    FileAssociator.addAssociation("BIN", new File(".").getCanonicalPath() + File.separator + "RomRaider" + ".exe", "ECU Image");
                }
            }
            catch (Exception exception) {}
        } else if (mouseEvent.getSource() == this.btnRemoveAssocs) {
            if (this.extensionHex.isSelected()) {
                FileAssociator.removeAssociation("HEX");
            }
            if (this.extensionBin.isSelected()) {
                FileAssociator.removeAssociation("BIN");
            }
        }
    }

    public void applySettings() {
        try {
            Integer.parseInt(this.cellHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.cellHeight.setText((int)this.settings.getCellSize().getHeight() + "");
        }
        try {
            Integer.parseInt(this.cellWidth.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.cellWidth.setText((int)this.settings.getCellSize().getWidth() + "");
        }
        this.settings.setObsoleteWarning(this.obsoleteWarning.isSelected());
        this.settings.setCalcConflictWarning(this.calcConflictWarning.isSelected());
        this.settings.setDisplayHighTables(this.displayHighTables.isSelected());
        this.settings.setSaveDebugTables(this.saveDebugTables.isSelected());
        this.settings.setDebug(this.debug.isSelected());
        this.settings.setMaxColor(this.maxColor.getBackground());
        this.settings.setMinColor(this.minColor.getBackground());
        this.settings.setHighlightColor(this.highlightColor.getBackground());
        this.settings.setAxisColor(this.axisColor.getBackground());
        this.settings.setIncreaseBorder(this.increaseColor.getBackground());
        this.settings.setDecreaseBorder(this.decreaseColor.getBackground());
        this.settings.setCellSize(new Dimension(Integer.parseInt(this.cellWidth.getText()), Integer.parseInt(this.cellHeight.getText())));
        this.settings.setTableFont(this.btnChooseFont.getFont());
        if (this.tableClickCount.getSelectedIndex() == 0) {
            this.settings.setTableClickCount(1);
        } else {
            this.settings.setTableClickCount(2);
        }
        this.settings.setValueLimitWarning(this.valueLimitWarning.isSelected());
        this.settings.setWarningColor(this.warningColor.getBackground());
        this.parent.setSettings(this.settings);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

