/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.swing.MDIDesktopManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDIDesktopPane
extends JDesktopPane {
    private static final long serialVersionUID = -1839360490978587035L;
    private static int FRAME_OFFSET = 20;
    private MDIDesktopManager manager = new MDIDesktopManager(this);

    public MDIDesktopPane() {
        this.setDesktopManager(this.manager);
        this.setDragMode(1);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame jInternalFrame) {
        Point point;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        Component component = super.add(jInternalFrame);
        this.checkDesktopSize();
        if (jInternalFrameArray.length > 0) {
            point = jInternalFrameArray[0].getLocation();
            point.x += FRAME_OFFSET;
            point.y += FRAME_OFFSET;
        } else {
            point = new Point(0, 0);
        }
        jInternalFrame.setLocation(point.x, point.y);
        if (jInternalFrame.isResizable()) {
            int n = this.getWidth() - this.getWidth() / 3;
            int n2 = this.getHeight() - this.getHeight() / 3;
            if ((double)n < jInternalFrame.getMinimumSize().getWidth()) {
                n = (int)jInternalFrame.getMinimumSize().getWidth();
            }
            if ((double)n2 < jInternalFrame.getMinimumSize().getHeight()) {
                n2 = (int)jInternalFrame.getMinimumSize().getHeight();
            }
            jInternalFrame.setSize(n, n2);
        }
        this.moveToFront(jInternalFrame);
        jInternalFrame.setVisible(true);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            jInternalFrame.toBack();
        }
        return component;
    }

    public void remove(Component component) {
        super.remove(component);
        this.checkDesktopSize();
    }

    public void cascadeFrames() {
        int n = 0;
        int n2 = 0;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        this.manager.setNormalSize();
        int n3 = this.getBounds().height - 5 - jInternalFrameArray.length * FRAME_OFFSET;
        int n4 = this.getBounds().width - 5 - jInternalFrameArray.length * FRAME_OFFSET;
        for (int i = jInternalFrameArray.length - 1; i >= 0; --i) {
            jInternalFrameArray[i].setSize(n4, n3);
            jInternalFrameArray[i].setLocation(n, n2);
            n += FRAME_OFFSET;
            n2 += FRAME_OFFSET;
        }
    }

    public void tileFrames() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        this.manager.setNormalSize();
        int n = this.getBounds().height / jInternalFrameArray.length;
        int n2 = 0;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            jInternalFrameArray[i].setSize(this.getBounds().width, n);
            jInternalFrameArray[i].setLocation(0, n2);
            n2 += n;
        }
    }

    public void setAllSize(Dimension dimension) {
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void setAllSize(int n, int n2) {
        this.setAllSize(new Dimension(n, n2));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }
}

