/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.romraider.ECUEditor;
import com.romraider.maps.Rom;
import com.romraider.swing.DebugPanel;
import com.romraider.swing.ECUEditorMenuBar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public class ECUEditorToolBar
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = 7778170684606193919L;
    private ECUEditor parent;
    private JButton openImage = new JButton(new ImageIcon("./graphics/icon-open.png"));
    private JButton saveImage = new JButton(new ImageIcon("./graphics/icon-save.png"));
    private JButton refreshImage = new JButton(new ImageIcon("./graphics/icon-refresh.png"));
    private JButton closeImage = new JButton(new ImageIcon("./graphics/icon-close.png"));

    public ECUEditorToolBar(ECUEditor eCUEditor) {
        this.parent = eCUEditor;
        this.setFloatable(false);
        this.add(this.openImage);
        this.add(this.saveImage);
        this.add(this.closeImage);
        this.add(this.refreshImage);
        this.openImage.setMaximumSize(new Dimension(58, 50));
        this.openImage.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 0));
        this.saveImage.setMaximumSize(new Dimension(50, 50));
        this.saveImage.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 0));
        this.closeImage.setMaximumSize(new Dimension(50, 50));
        this.closeImage.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 0));
        this.refreshImage.setMaximumSize(new Dimension(50, 50));
        this.refreshImage.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150), 0));
        this.updateButtons();
        this.openImage.addActionListener(this);
        this.saveImage.addActionListener(this);
        this.closeImage.addActionListener(this);
        this.refreshImage.addActionListener(this);
    }

    public void updateButtons() {
        String string = this.getLastSelectedRomFileName();
        this.openImage.setToolTipText("Open Image");
        this.saveImage.setToolTipText("Save " + string);
        this.refreshImage.setToolTipText("Refresh " + string + " from saved copy");
        this.closeImage.setToolTipText("Close " + string);
        if ("".equals(string)) {
            this.saveImage.setEnabled(false);
            this.refreshImage.setEnabled(false);
            this.closeImage.setEnabled(false);
        } else {
            this.saveImage.setEnabled(true);
            this.refreshImage.setEnabled(true);
            this.closeImage.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.openImage) {
            try {
                ((ECUEditorMenuBar)this.parent.getJMenuBar()).openImageDialog();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.parent, new DebugPanel(exception, this.parent.getSettings().getSupportURL()), "Exception", 0);
            }
        } else if (actionEvent.getSource() == this.saveImage) {
            try {
                ((ECUEditorMenuBar)this.parent.getJMenuBar()).saveImage(this.parent.getLastSelectedRom());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.parent, new DebugPanel(exception, this.parent.getSettings().getSupportURL()), "Exception", 0);
            }
        } else if (actionEvent.getSource() == this.closeImage) {
            ((ECUEditorMenuBar)this.parent.getJMenuBar()).closeImage();
        } else if (actionEvent.getSource() == this.refreshImage) {
            try {
                ((ECUEditorMenuBar)this.parent.getJMenuBar()).refreshImage();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.parent, new DebugPanel(exception, this.parent.getSettings().getSupportURL()), "Exception", 0);
            }
        }
    }

    private String getLastSelectedRomFileName() {
        Rom rom = this.parent.getLastSelectedRom();
        return rom == null ? "" : rom.getFileName() + " ";
    }
}

