/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.swing;

import com.centerkey.utils.BareBonesBrowserLaunch;
import com.romraider.ECUEditor;
import com.romraider.Version;
import com.romraider.logger.ecu.EcuLogger;
import com.romraider.maps.Rom;
import com.romraider.ramtune.test.RamTuneTestApp;
import com.romraider.swing.DebugPanel;
import com.romraider.swing.DefinitionManager;
import com.romraider.swing.ECUImageFilter;
import com.romraider.swing.RomPropertyPanel;
import com.romraider.swing.SettingsForm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class ECUEditorMenuBar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = -4777040428837855236L;
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem openImage = new JMenuItem("Open Image...");
    private JMenuItem saveImage = new JMenuItem("Save Image...");
    private JMenuItem refreshImage = new JMenuItem("Refresh Image");
    private JMenuItem closeImage = new JMenuItem("Close Image");
    private JMenuItem closeAll = new JMenuItem("Close All Images");
    private JMenuItem exit = new JMenuItem("Exit");
    private JMenu definitionMenu = new JMenu("ECU Definitions");
    private JMenuItem defManager = new JMenuItem("ECU Definition Manager...");
    private JMenuItem updateDefinition = new JMenuItem("Get ECU Definitions...");
    private JMenu editMenu = new JMenu("Edit");
    private JMenuItem settings = new JMenuItem("RomRaider Settings...");
    private JMenu viewMenu = new JMenu("View");
    private JMenuItem romProperties = new JMenuItem("ECU Image Properties");
    private ButtonGroup levelGroup = new ButtonGroup();
    private JMenu levelMenu = new JMenu("User Level");
    private JRadioButtonMenuItem level1 = new JRadioButtonMenuItem("1 Beginner");
    private JRadioButtonMenuItem level2 = new JRadioButtonMenuItem("2 Intermediate");
    private JRadioButtonMenuItem level3 = new JRadioButtonMenuItem("3 Advanced");
    private JRadioButtonMenuItem level4 = new JRadioButtonMenuItem("4 Highest");
    private JRadioButtonMenuItem level5 = new JRadioButtonMenuItem("5 Debug Mode");
    private JMenu loggerMenu = new JMenu("Logger");
    private JMenuItem openLogger = new JMenuItem("Launch ECU Logger...");
    private JMenu ramTuneMenu = new JMenu("SSM");
    private JMenuItem launchRamTuneTestApp = new JMenuItem("Launch Test App...");
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem about = new JMenuItem("About RomRaider");
    private ECUEditor parent;

    public ECUEditorMenuBar(ECUEditor eCUEditor) {
        this.parent = eCUEditor;
        this.add(this.fileMenu);
        this.fileMenu.setMnemonic('F');
        this.openImage.setMnemonic('O');
        this.saveImage.setMnemonic('S');
        this.refreshImage.setMnemonic('R');
        this.closeImage.setMnemonic('C');
        this.closeAll.setMnemonic('A');
        this.exit.setMnemonic('X');
        this.fileMenu.add(this.openImage);
        this.fileMenu.add(this.saveImage);
        this.fileMenu.add(this.refreshImage);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.closeImage);
        this.fileMenu.add(this.closeAll);
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(this.exit);
        this.openImage.addActionListener(this);
        this.saveImage.addActionListener(this);
        this.refreshImage.addActionListener(this);
        this.closeImage.addActionListener(this);
        this.closeAll.addActionListener(this);
        this.exit.addActionListener(this);
        this.add(this.editMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.add(this.settings);
        this.settings.addActionListener(this);
        this.add(this.definitionMenu);
        this.definitionMenu.setMnemonic('D');
        this.defManager.setMnemonic('D');
        this.updateDefinition.setMnemonic('U');
        this.settings.setMnemonic('S');
        this.definitionMenu.add(this.defManager);
        this.definitionMenu.add(this.updateDefinition);
        this.defManager.addActionListener(this);
        this.updateDefinition.addActionListener(this);
        this.add(this.viewMenu);
        this.viewMenu.setMnemonic('V');
        this.romProperties.setMnemonic('P');
        this.levelMenu.setMnemonic('U');
        this.level1.setMnemonic('1');
        this.level2.setMnemonic('2');
        this.level3.setMnemonic('3');
        this.level4.setMnemonic('4');
        this.level5.setMnemonic('5');
        this.viewMenu.add(this.romProperties);
        this.viewMenu.add(this.levelMenu);
        this.levelMenu.add(this.level1);
        this.levelMenu.add(this.level2);
        this.levelMenu.add(this.level3);
        this.levelMenu.add(this.level4);
        this.levelMenu.add(this.level5);
        this.romProperties.addActionListener(this);
        this.level1.addActionListener(this);
        this.level2.addActionListener(this);
        this.level3.addActionListener(this);
        this.level4.addActionListener(this);
        this.level5.addActionListener(this);
        this.levelGroup.add(this.level1);
        this.levelGroup.add(this.level2);
        this.levelGroup.add(this.level3);
        this.levelGroup.add(this.level4);
        this.levelGroup.add(this.level5);
        if (eCUEditor.getSettings().getUserLevel() == 1) {
            this.level1.setSelected(true);
        } else if (eCUEditor.getSettings().getUserLevel() == 2) {
            this.level2.setSelected(true);
        } else if (eCUEditor.getSettings().getUserLevel() == 3) {
            this.level3.setSelected(true);
        } else if (eCUEditor.getSettings().getUserLevel() == 4) {
            this.level4.setSelected(true);
        } else if (eCUEditor.getSettings().getUserLevel() == 5) {
            this.level5.setSelected(true);
        }
        this.add(this.loggerMenu);
        this.loggerMenu.setMnemonic('L');
        this.openLogger.setMnemonic('O');
        this.loggerMenu.add(this.openLogger);
        this.openLogger.addActionListener(this);
        this.add(this.ramTuneMenu);
        this.ramTuneMenu.setMnemonic('R');
        this.launchRamTuneTestApp.setMnemonic('L');
        this.ramTuneMenu.add(this.launchRamTuneTestApp);
        this.launchRamTuneTestApp.addActionListener(this);
        this.add(this.helpMenu);
        this.helpMenu.setMnemonic('H');
        this.about.setMnemonic('A');
        this.helpMenu.add(this.about);
        this.about.addActionListener(this);
        this.updateMenu();
    }

    public void updateMenu() {
        String string = this.getLastSelectedRomFileName();
        if ("".equals(string)) {
            this.saveImage.setEnabled(false);
            this.closeImage.setEnabled(false);
            this.closeAll.setEnabled(false);
            this.romProperties.setEnabled(false);
            this.saveImage.setText("Save...");
        } else {
            this.saveImage.setEnabled(true);
            this.closeImage.setEnabled(true);
            this.closeAll.setEnabled(true);
            this.romProperties.setEnabled(true);
            this.saveImage.setText("Save " + string + "...");
        }
        this.refreshImage.setText("Refresh " + string);
        this.closeImage.setText("Close " + string);
        this.romProperties.setText(string + "Properties");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.openImage) {
            try {
                this.openImageDialog();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.parent, new DebugPanel(exception, this.parent.getSettings().getSupportURL()), "Exception", 0);
            }
        } else if (actionEvent.getSource() == this.saveImage) {
            try {
                this.saveImage(this.parent.getLastSelectedRom());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.parent, new DebugPanel(exception, this.parent.getSettings().getSupportURL()), "Exception", 0);
            }
        } else if (actionEvent.getSource() == this.closeImage) {
            this.closeImage();
        } else if (actionEvent.getSource() == this.closeAll) {
            this.closeAllImages();
        } else if (actionEvent.getSource() == this.exit) {
            this.parent.handleExit();
            System.exit(0);
        } else if (actionEvent.getSource() == this.romProperties) {
            JOptionPane.showMessageDialog(this.parent, new RomPropertyPanel(this.parent.getLastSelectedRom()), this.parent.getLastSelectedRom().getRomIDString() + " Properties", 1);
        } else if (actionEvent.getSource() == this.refreshImage) {
            try {
                this.refreshImage();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.parent, new DebugPanel(exception, this.parent.getSettings().getSupportURL()), "Exception", 0);
            }
        } else if (actionEvent.getSource() == this.settings) {
            SettingsForm settingsForm = new SettingsForm(this.parent);
            settingsForm.setLocationRelativeTo(this.parent);
            settingsForm.setVisible(true);
        } else if (actionEvent.getSource() == this.defManager) {
            DefinitionManager definitionManager = new DefinitionManager(this.parent);
            definitionManager.setLocationRelativeTo(this.parent);
            definitionManager.setVisible(true);
        } else if (actionEvent.getSource() == this.level1) {
            this.parent.setUserLevel(1);
        } else if (actionEvent.getSource() == this.level2) {
            this.parent.setUserLevel(2);
        } else if (actionEvent.getSource() == this.level3) {
            this.parent.setUserLevel(3);
        } else if (actionEvent.getSource() == this.level4) {
            this.parent.setUserLevel(4);
        } else if (actionEvent.getSource() == this.level5) {
            this.parent.setUserLevel(5);
        } else if (actionEvent.getSource() == this.openLogger) {
            EcuLogger.startLogger(2, this.parent);
        } else if (actionEvent.getSource() == this.updateDefinition) {
            BareBonesBrowserLaunch.openURL("http://www.romraider.com/forum/topic360.html");
        } else if (actionEvent.getSource() == this.launchRamTuneTestApp) {
            RamTuneTestApp.startTestApp(2);
        } else if (actionEvent.getSource() == this.about) {
            String string = "RomRaider - ECU Editor\nVersion: 0.5.2 Beta \nBuild #: 223\nhttp://www.romraider.com";
            String string2 = "About RomRaider";
            JOptionPane.showMessageDialog(this.parent, string, string2, 1, Version.ABOUT_ICON);
        }
    }

    public void refreshImage() throws Exception {
        if (this.parent.getLastSelectedRom() != null) {
            File file = this.parent.getLastSelectedRom().getFullFileName();
            this.parent.closeImage();
            this.parent.openImage(file);
        }
    }

    public void openImageDialog() throws Exception {
        JFileChooser jFileChooser = new JFileChooser(this.parent.getSettings().getLastImageDir());
        jFileChooser.setFileFilter(new ECUImageFilter());
        if (jFileChooser.showOpenDialog(this.parent) == 0) {
            this.parent.openImage(jFileChooser.getSelectedFile());
            this.parent.getSettings().setLastImageDir(jFileChooser.getCurrentDirectory());
        }
    }

    public void closeImage() {
        this.parent.closeImage();
    }

    public void closeAllImages() {
        this.parent.closeAllImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImage(Rom rom) throws Exception {
        if (this.parent.getLastSelectedRom() != null) {
            JFileChooser jFileChooser = new JFileChooser(this.parent.getSettings().getLastImageDir());
            jFileChooser.setFileFilter(new ECUImageFilter());
            if (jFileChooser.showSaveDialog(this.parent) == 0) {
                boolean bl = true;
                File file = jFileChooser.getSelectedFile();
                if (file.exists() && JOptionPane.showConfirmDialog(this.parent, file.getName() + " already exists! Overwrite?") == 2) {
                    bl = false;
                }
                if (bl) {
                    byte[] byArray = this.parent.getLastSelectedRom().saveFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    try {
                        fileOutputStream.write(byArray);
                    }
                    finally {
                        fileOutputStream.close();
                    }
                    this.parent.getLastSelectedRom().setFullFileName(file.getAbsoluteFile());
                    this.parent.setLastSelectedRom(this.parent.getLastSelectedRom());
                    this.parent.getSettings().setLastImageDir(file.getParentFile());
                }
            }
        }
    }

    private String getLastSelectedRomFileName() {
        Rom rom = this.parent.getLastSelectedRom();
        return rom == null ? "" : rom.getFileName() + " ";
    }
}

