/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.maps.Table;
import com.romraider.xml.RomAttributeParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;

public class TableSwitch
extends Table {
    private static final long serialVersionUID = -4887718305447362308L;
    private byte[] on = new byte[0];
    private byte[] off = new byte[0];
    private JCheckBox checkbox = new JCheckBox("Enabled", true);

    public TableSwitch(Settings settings) {
        super(settings);
        this.storageType = 1;
        this.type = 6;
        this.removeAll();
        this.setLayout(new BorderLayout());
    }

    public void setDataSize(int n) {
        if (this.on.length == 0) {
            this.on = new byte[n];
            this.off = new byte[n];
        }
    }

    public void populateTable(byte[] byArray) {
        for (int i = 0; i < this.on.length; ++i) {
            if (!this.beforeRam) {
                this.ramOffset = this.container.getRomID().getRamOffset();
            }
            if (this.on[i] == byArray[this.storageAddress - this.ramOffset + i]) continue;
            this.checkbox.setSelected(false);
            break;
        }
    }

    public void setName(String string) {
        super.setName(string);
        this.checkbox.setText("Enable " + string);
        this.add((Component)this.checkbox, "North");
    }

    public int getType() {
        return 6;
    }

    public void setDescription(String string) {
        super.setDescription(string);
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        this.add((Component)jTextArea, "Center");
    }

    public byte[] saveFile(byte[] byArray) {
        if (this.checkbox.isSelected()) {
            for (int i = 0; i < this.on.length; ++i) {
                byArray[this.storageAddress - this.ramOffset + i] = this.on[i];
            }
        } else {
            for (int i = 0; i < this.on.length; ++i) {
                byArray[this.storageAddress - this.ramOffset + i] = this.off[i];
            }
        }
        return byArray;
    }

    public void setOnValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < this.off.length; ++i) {
            this.on[i] = (byte)RomAttributeParser.parseHexString(stringTokenizer.nextToken());
        }
    }

    public void setOffValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < this.off.length; ++i) {
            this.off[i] = (byte)RomAttributeParser.parseHexString(stringTokenizer.nextToken());
        }
    }

    public byte[] getOnValues() {
        return this.on;
    }

    public byte[] getOffValues() {
        return this.off;
    }

    public Dimension getFrameSize() {
        int n;
        int n2 = this.verticalOverhead + 75;
        int n3 = this.horizontalOverhead;
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        }
        int n4 = n = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (n3 < n) {
            n3 = n;
        }
        return new Dimension(n3, n2);
    }

    public void colorize() {
    }

    public void cursorUp() {
    }

    public void cursorDown() {
    }

    public void cursorLeft() {
    }

    public void cursorRight() {
    }

    public void setAxisColor(Color color) {
    }

    public boolean isLiveDataSupported() {
        return false;
    }
}

