/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.innovate.lm1.plugin;

import com.romraider.logger.innovate.generic.plugin.DataConvertor;
import com.romraider.util.ByteUtil;
import com.romraider.util.HexUtil;
import org.apache.log4j.Logger;

public final class Lm1DataConvertor
implements DataConvertor {
    private static final Logger LOGGER = Logger.getLogger(Lm1DataConvertor.class);
    private static final double MAX_AFR = 20.33;

    public double convert(byte[] byArray) {
        LOGGER.trace((Object)("Converting LM-1 bytes: " + HexUtil.asHex(byArray)));
        if (this.isLm1(byArray) && this.isHeaderValid(byArray)) {
            if (this.isError(byArray)) {
                int n = -1 * this.getLambda(byArray);
                LOGGER.error((Object)("LM-1 error: " + HexUtil.asHex(byArray) + " --> " + n));
                return n;
            }
            if (this.isOk(byArray)) {
                double d = this.getAfr(byArray);
                LOGGER.trace((Object)("LM-1 AFR: " + d));
                return d > 20.33 ? 20.33 : d;
            }
            LOGGER.trace((Object)("LM-1 response out of range (overrun?): " + HexUtil.asHex(byArray)));
            return 20.33;
        }
        LOGGER.error((Object)("LM-1 unrecognized response: " + HexUtil.asHex(byArray)));
        return 0.0;
    }

    private double getAfr(byte[] byArray) {
        return (double)((this.getLambda(byArray) + 500) * this.getAf(byArray)) / 10000.0;
    }

    private int getAf(byte[] byArray) {
        return (byArray[2] & 1) << 7 | byArray[3];
    }

    private boolean isLm1(byte[] byArray) {
        return byArray.length >= 6 && ByteUtil.matchOnes(byArray[2], 128) && ByteUtil.matchZeroes(byArray[2], 34);
    }

    private boolean isHeaderValid(byte[] byArray) {
        return ByteUtil.matchOnes(byArray[0], 178) && ByteUtil.matchOnes(byArray[1], 128);
    }

    private boolean isOk(byte[] byArray) {
        return ByteUtil.matchOnes(byArray[2], 128) && ByteUtil.matchZeroes(byArray[2], 62);
    }

    private boolean isError(byte[] byArray) {
        return ByteUtil.matchOnes(byArray[2], 152) && ByteUtil.matchZeroes(byArray[2], 38);
    }

    private int getLambda(byte[] byArray) {
        return byArray[4] << 7 | byArray[5];
    }

    public static void main(String[] stringArray) {
        byte[] byArray = HexUtil.asBytes("0xB2808113036F1E650124007000470039003A");
        Lm1DataConvertor lm1DataConvertor = new Lm1DataConvertor();
        double d = lm1DataConvertor.convert(byArray);
        System.out.println("result = " + d);
    }
}

