/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.innovate.generic.io;

import com.romraider.io.connection.ConnectionProperties;
import com.romraider.io.serial.connection.SerialConnection;
import com.romraider.io.serial.connection.SerialConnectionImpl;
import com.romraider.logger.ecu.exception.SerialCommunicationException;
import com.romraider.logger.innovate.generic.io.InnovateConnection;
import com.romraider.util.ByteUtil;
import com.romraider.util.HexUtil;
import com.romraider.util.ParamChecker;
import com.romraider.util.ThreadUtil;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class InnovateConnectionImpl
implements InnovateConnection {
    private static final Logger LOGGER = Logger.getLogger(InnovateConnectionImpl.class);
    private static final byte[] INNOVATE_HEADER = HexUtil.asBytes("0xB280");
    private final SerialConnection connection;
    private final int responseLength;
    private final long sendTimeout;
    private final String device;

    public InnovateConnectionImpl(String string, String string2, ConnectionProperties connectionProperties, int n) {
        ParamChecker.checkNotNullOrEmpty(string, "device");
        ParamChecker.checkNotNullOrEmpty(string2, "portName");
        ParamChecker.checkNotNull((Object)connectionProperties, "connectionProperties");
        ParamChecker.checkGreaterThanZero(n, "responseLength");
        this.device = string;
        this.sendTimeout = connectionProperties.getSendTimeout();
        this.responseLength = n;
        this.connection = new SerialConnectionImpl(string2, connectionProperties);
        LOGGER.info((Object)(string + " connected"));
    }

    public byte[] read() {
        try {
            this.connection.readStaleData();
            byte[] byArray = new byte[this.responseLength];
            int n = this.responseLength + INNOVATE_HEADER.length - 1;
            long l = System.currentTimeMillis();
            while (System.currentTimeMillis() - l <= this.sendTimeout) {
                ThreadUtil.sleep(1L);
                int n2 = this.connection.available();
                if (n2 < n) continue;
                byte[] byArray2 = new byte[n];
                this.connection.read(byArray2);
                LOGGER.trace((Object)(this.device + " input: " + HexUtil.asHex(byArray2)));
                int n3 = 0;
                int n4 = this.findHeader(byArray2);
                if (n4 < 0) {
                    n4 = this.findLm1(byArray2);
                    if (n4 < 0) continue;
                    LOGGER.trace((Object)(this.device + ": v1 protocol found - appending header..."));
                    System.arraycopy(INNOVATE_HEADER, 0, byArray, 0, INNOVATE_HEADER.length);
                    n3 = INNOVATE_HEADER.length;
                }
                int n5 = this.responseLength - n3;
                System.arraycopy(byArray2, n4, byArray, n3, Math.min(n5, byArray2.length - n4));
                int n6 = n5 - (byArray2.length - n4);
                if (n6 > 0) {
                    byte[] byArray3 = this.remainder(n6, l);
                    if (byArray3.length == 0) continue;
                    System.arraycopy(byArray3, 0, byArray, this.responseLength - n6, n6);
                }
                LOGGER.trace((Object)(this.device + " Response: " + HexUtil.asHex(byArray)));
                return byArray;
            }
            LOGGER.warn((Object)(this.device + " Response [read timeout]"));
            return new byte[0];
        }
        catch (Exception exception) {
            this.close();
            throw new SerialCommunicationException(exception);
        }
    }

    private byte[] remainder(int n, long l) throws IOException {
        while (System.currentTimeMillis() - l <= this.sendTimeout) {
            ThreadUtil.sleep(1L);
            int n2 = this.connection.available();
            if (n2 < n) continue;
            byte[] byArray = new byte[n];
            this.connection.read(byArray);
            return byArray;
        }
        return new byte[0];
    }

    public void close() {
        this.connection.close();
        LOGGER.info((Object)(this.device + " disconnected"));
    }

    private int findHeader(byte[] byArray) {
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (!ByteUtil.matchOnes(byArray[i], 178) || !ByteUtil.matchOnes(byArray[i + 1], 128)) continue;
            return i;
        }
        return -1;
    }

    private int findLm1(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (!ByteUtil.matchOnes(byArray[i], 128) || !ByteUtil.matchZeroes(byArray[i], 34)) continue;
            return i;
        }
        return -1;
    }
}

