/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar.util;

import com.romraider.logger.ecu.profile.UserProfile;
import com.romraider.swing.GenericFileFilter;
import com.romraider.util.ParamChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;

public final class FileHelper {
    private static final String USER_HOME_DIR = System.getProperty("user.home");

    private FileHelper() {
        throw new UnsupportedOperationException();
    }

    public static File getFile(String string) {
        return ParamChecker.isNullOrEmpty(string) ? new File(USER_HOME_DIR) : new File(string);
    }

    public static JFileChooser getProfileFileChooser(File file) {
        return FileHelper.getFileChooser(file, "ECU Logger User Profiles", "xml");
    }

    public static JFileChooser getDefinitionFileChooser(File file) {
        return FileHelper.getFileChooser(file, "ECU Logger Definitions", "xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveProfileToFile(UserProfile userProfile, File file) throws IOException {
        String string = file.getAbsolutePath();
        if (!string.endsWith(".xml")) {
            string = string + ".xml";
            file = new File(string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(userProfile.getBytes());
        }
        finally {
            fileOutputStream.close();
        }
        return string;
    }

    public static JFileChooser getLoggerOutputDirFileChooser(File file) {
        JFileChooser jFileChooser = file.exists() && file.isDirectory() ? new JFileChooser(file.getAbsolutePath()) : new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        return jFileChooser;
    }

    private static JFileChooser getFileChooser(File file, String string, String ... stringArray) {
        JFileChooser jFileChooser = FileHelper.getFileChooser(file);
        jFileChooser.setFileFilter(new GenericFileFilter(string, stringArray));
        return jFileChooser;
    }

    private static JFileChooser getFileChooser(File file) {
        if (file.exists() && file.isFile() && file.getParentFile() != null) {
            String string = file.getParentFile().getAbsolutePath();
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setSelectedFile(file);
            return jFileChooser;
        }
        return new JFileChooser();
    }
}

