/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar.action;

import com.romraider.logger.ecu.EcuLogger;
import com.romraider.logger.ecu.ui.swing.menubar.action.AbstractAction;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public final class ResetEcuAction
extends AbstractAction {
    public ResetEcuAction(EcuLogger ecuLogger) {
        super(ecuLogger);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.showConfirmation() == 0) {
            boolean bl = this.logger.isLogging();
            if (bl) {
                this.logger.stopLogging();
            }
            this.resetEcu();
            if (bl) {
                this.logger.startLogging();
            }
        }
    }

    private int showConfirmation() {
        return JOptionPane.showConfirmDialog(this.logger, "Do you want to reset the ECU?", "Reset ECU", 0, 2);
    }

    private void resetEcu() {
        if (this.doReset()) {
            JOptionPane.showMessageDialog(this.logger, "Reset Successful!\nTurn your ignition OFF and then\nback ON to complete the process.", "Reset ECU", 1);
        } else {
            JOptionPane.showMessageDialog(this.logger, "Error performing ECU reset.\nCheck the following:\n* Correct COM port selected\n* Cable is connected properly\n* Ignition is ON\n* Logger is stopped", "Reset ECU", 0);
        }
    }

    private boolean doReset() {
        try {
            return this.logger.resetEcu();
        }
        catch (Exception exception) {
            this.logger.reportError("Error performing ECU reset", exception);
            return false;
        }
    }
}

