/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.table;

import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.maps.Table;
import com.romraider.maps.Table2D;
import com.romraider.maps.Table3D;
import com.romraider.util.ParamChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TableUpdateHandler
implements DataUpdateHandler {
    private static final TableUpdateHandler INSTANCE = new TableUpdateHandler();
    private final Map<String, List<Table>> tableMap = Collections.synchronizedMap(new HashMap());

    private TableUpdateHandler() {
    }

    public void registerData(LoggerData loggerData) {
    }

    public void handleDataUpdate(Response response) {
        for (LoggerData loggerData : response.getData()) {
            List<Table> list = this.tableMap.get(loggerData.getId());
            if (list == null || list.isEmpty()) continue;
            String string = loggerData.getSelectedConvertor().format(response.getDataValue(loggerData));
            for (Table table : list) {
                table.setLiveValue(string);
            }
        }
    }

    public void deregisterData(LoggerData loggerData) {
    }

    public void cleanUp() {
    }

    public void reset() {
    }

    public void registerTable(Table table) {
        String string = table.getLogParam();
        if (!ParamChecker.isNullOrEmpty(string)) {
            List<Table> list;
            if (!this.tableMap.containsKey(string)) {
                this.tableMap.put(string, new ArrayList());
            }
            if (!(list = this.tableMap.get(string)).contains(table)) {
                list.add(table);
            }
        }
        this.registerAxes(table);
    }

    public void deregisterTable(Table table) {
        String string = table.getLogParam();
        if (this.tableMap.containsKey(string)) {
            List<Table> list = this.tableMap.get(string);
            list.remove(table);
            if (list.isEmpty()) {
                this.tableMap.remove(string);
            }
        }
        this.deregisterAxes(table);
    }

    public static TableUpdateHandler getInstance() {
        return INSTANCE;
    }

    private void registerAxes(Table table) {
        if (table instanceof Table2D) {
            this.registerTable(((Table2D)table).getAxis());
        }
        if (table instanceof Table3D) {
            this.registerTable(((Table3D)table).getXAxis());
            this.registerTable(((Table3D)table).getYAxis());
        }
    }

    private void deregisterAxes(Table table) {
        if (table instanceof Table2D) {
            this.deregisterTable(((Table2D)table).getAxis());
        }
        if (table instanceof Table3D) {
            this.deregisterTable(((Table3D)table).getXAxis());
            this.deregisterTable(((Table3D)table).getYAxis());
        }
    }
}

