/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.graph;

import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.definition.ConvertorUpdateListener;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.handler.graph.SpringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class GraphUpdateHandler
implements DataUpdateHandler,
ConvertorUpdateListener {
    private static final Color DARK_GREY = new Color(80, 80, 80);
    private static final Color LIGHT_GREY = new Color(110, 110, 110);
    private final Map<LoggerData, ChartPanel> chartMap = Collections.synchronizedMap(new HashMap());
    private final Map<LoggerData, XYSeries> seriesMap = Collections.synchronizedMap(new HashMap());
    private final Map<LoggerData, Integer> datasetIndexes = Collections.synchronizedMap(new HashMap());
    private final JPanel graphPanel;
    private long startTime = System.currentTimeMillis();
    private boolean combinedChart = false;
    private boolean paused = false;
    private long pauseStartTime = System.currentTimeMillis();
    private ChartPanel combinedChartPanel = null;
    private int counter = 0;

    public GraphUpdateHandler(JPanel jPanel) {
        this.graphPanel = new JPanel(new SpringLayout());
        final JCheckBox jCheckBox = new JCheckBox("Combine Graphs", this.combinedChart);
        jCheckBox.addActionListener(new CombinedActionListener(jCheckBox));
        JToggleButton jToggleButton = new JToggleButton("Pause Graphs");
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphUpdateHandler.this.paused = !GraphUpdateHandler.this.paused;
                if (GraphUpdateHandler.this.paused) {
                    GraphUpdateHandler.this.pauseStartTime = System.currentTimeMillis();
                } else {
                    GraphUpdateHandler.this.startTime = GraphUpdateHandler.this.startTime + (System.currentTimeMillis() - GraphUpdateHandler.this.pauseStartTime);
                }
            }
        });
        jPanel.getInputMap(2).put(KeyStroke.getKeyStroke("F12"), "toggleCombineGraphs");
        jPanel.getActionMap().put("toggleCombineGraphs", new AbstractAction(){
            private static final long serialVersionUID = 1540427179539775534L;

            public void actionPerformed(ActionEvent actionEvent) {
                jCheckBox.doClick();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jCheckBox);
        jPanel2.add(jToggleButton);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.graphPanel, "Center");
    }

    public synchronized void registerData(LoggerData loggerData) {
        this.registerSeries(loggerData);
        if (this.combinedChart) {
            this.addToCombined(loggerData);
            this.layoutForCombined();
        } else {
            this.addToPanel(loggerData);
            this.layoutForPanel();
        }
        this.graphPanel.updateUI();
    }

    private synchronized void addToPanel(LoggerData loggerData) {
        XYSeries xYSeries = this.seriesMap.get(loggerData);
        ChartPanel chartPanel = new ChartPanel(this.createXYLineChart(loggerData, (XYDataset)new XYSeriesCollection(xYSeries), false), false, true, true, true, true);
        chartPanel.setMinimumSize(new Dimension(600, 200));
        chartPanel.setMaximumSize(new Dimension(10000, 200));
        chartPanel.setPreferredSize(new Dimension(600, 200));
        this.chartMap.put(loggerData, chartPanel);
        this.graphPanel.add((Component)chartPanel);
    }

    private void layoutForPanel() {
        SpringUtilities.makeCompactGrid(this.graphPanel, this.seriesMap.size(), 1, 2, 2, 2, 2);
    }

    private synchronized void addToCombined(LoggerData loggerData) {
        XYPlot xYPlot;
        if (this.combinedChartPanel == null) {
            this.combinedChartPanel = new ChartPanel(this.createXYLineChart(loggerData, null, true), false, true, true, true, true);
            xYPlot = new LegendTitle((LegendItemSource)this.combinedChartPanel.getChart().getXYPlot());
            xYPlot.setItemPaint((Paint)Color.WHITE);
            this.combinedChartPanel.getChart().addLegend((LegendTitle)xYPlot);
            this.combinedChartPanel.setMinimumSize(new Dimension(500, 400));
            this.combinedChartPanel.setPreferredSize(new Dimension(500, 400));
            this.graphPanel.add((Component)this.combinedChartPanel);
        }
        xYPlot = this.combinedChartPanel.getChart().getXYPlot();
        xYPlot.setDataset(this.counter, (XYDataset)new XYSeriesCollection(this.seriesMap.get(loggerData)));
        xYPlot.setRenderer(this.counter, (XYItemRenderer)new StandardXYItemRenderer());
        this.datasetIndexes.put(loggerData, this.counter++);
    }

    private void layoutForCombined() {
        SpringUtilities.makeCompactGrid(this.graphPanel, 1, 1, 2, 2, 2, 2);
    }

    public synchronized void handleDataUpdate(final Response response) {
        for (final LoggerData loggerData : response.getData()) {
            final XYSeries xYSeries = this.seriesMap.get(loggerData);
            if (xYSeries == null || this.paused) continue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    xYSeries.add((double)(response.getTimestamp() - GraphUpdateHandler.this.startTime) / 1000.0, response.getDataValue(loggerData));
                }
            });
        }
    }

    public synchronized void deregisterData(LoggerData loggerData) {
        this.seriesMap.remove(loggerData);
        if (this.combinedChart) {
            this.removeFromCombined(loggerData);
        } else {
            this.removeFromPanel(loggerData);
            this.layoutForPanel();
        }
        this.graphPanel.updateUI();
    }

    private void removeFromCombined(LoggerData loggerData) {
        if (this.datasetIndexes.containsKey(loggerData)) {
            this.combinedChartPanel.getChart().getXYPlot().setDataset(this.datasetIndexes.get(loggerData).intValue(), null);
        }
        this.datasetIndexes.remove(loggerData);
        this.chartMap.remove(loggerData);
        if (this.datasetIndexes.isEmpty()) {
            this.graphPanel.remove((Component)this.combinedChartPanel);
            this.combinedChartPanel = null;
        }
    }

    private void removeFromPanel(LoggerData loggerData) {
        this.graphPanel.remove((Component)this.chartMap.get(loggerData));
        this.datasetIndexes.remove(loggerData);
        this.chartMap.remove(loggerData);
    }

    public synchronized void cleanUp() {
    }

    public synchronized void reset() {
        for (XYSeries xYSeries : this.seriesMap.values()) {
            xYSeries.clear();
        }
    }

    public synchronized void notifyConvertorUpdate(LoggerData loggerData) {
        if (this.chartMap.containsKey(loggerData)) {
            this.seriesMap.get(loggerData).clear();
            JFreeChart jFreeChart = this.chartMap.get(loggerData).getChart();
            jFreeChart.getXYPlot().getRangeAxis().setLabel(this.buildRangeAxisTitle(loggerData));
        }
    }

    private void registerSeries(LoggerData loggerData) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)loggerData.getName()));
        xYSeries.setMaximumItemCount(200);
        this.seriesMap.put(loggerData, xYSeries);
    }

    private JFreeChart createXYLineChart(LoggerData loggerData, XYDataset xYDataset, boolean bl) {
        String string = bl ? "Combined Data" : loggerData.getName();
        String string2 = bl ? "Data" : this.buildRangeAxisTitle(loggerData);
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)string, (String)"Time (sec)", (String)string2, (XYDataset)xYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.BLACK);
        jFreeChart.getTitle().setPaint((Paint)Color.WHITE);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint((Paint)Color.BLACK);
        xYPlot.getDomainAxis().setLabelPaint((Paint)Color.WHITE);
        xYPlot.getRangeAxis().setLabelPaint((Paint)Color.WHITE);
        xYPlot.getDomainAxis().setTickLabelPaint((Paint)LIGHT_GREY);
        xYPlot.getRangeAxis().setTickLabelPaint((Paint)LIGHT_GREY);
        xYPlot.setDomainGridlinePaint((Paint)DARK_GREY);
        xYPlot.setRangeGridlinePaint((Paint)DARK_GREY);
        xYPlot.setOutlinePaint((Paint)DARK_GREY);
        return jFreeChart;
    }

    private String buildRangeAxisTitle(LoggerData loggerData) {
        return loggerData.getName() + " (" + loggerData.getSelectedConvertor().getUnits() + ")";
    }

    private final class CombinedActionListener
    implements ActionListener {
        private final JCheckBox combinedCheckbox;

        private CombinedActionListener(JCheckBox jCheckBox) {
            this.combinedCheckbox = jCheckBox;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphUpdateHandler.this.combinedChart = this.combinedCheckbox.isSelected();
            if (GraphUpdateHandler.this.combinedChart) {
                this.removeAllFromPanel();
                this.addAllToCombined();
                GraphUpdateHandler.this.layoutForCombined();
            } else {
                this.removeAllFromCombined();
                this.addAllToPanel();
                GraphUpdateHandler.this.layoutForPanel();
            }
            GraphUpdateHandler.this.graphPanel.updateUI();
        }

        private void addAllToCombined() {
            for (LoggerData loggerData : GraphUpdateHandler.this.seriesMap.keySet()) {
                GraphUpdateHandler.this.addToCombined(loggerData);
            }
        }

        private void removeAllFromPanel() {
            for (LoggerData loggerData : GraphUpdateHandler.this.seriesMap.keySet()) {
                GraphUpdateHandler.this.removeFromPanel(loggerData);
            }
        }

        private void addAllToPanel() {
            for (LoggerData loggerData : GraphUpdateHandler.this.seriesMap.keySet()) {
                GraphUpdateHandler.this.addToPanel(loggerData);
            }
        }

        private void removeAllFromCombined() {
            for (LoggerData loggerData : GraphUpdateHandler.this.seriesMap.keySet()) {
                GraphUpdateHandler.this.removeFromCombined(loggerData);
            }
        }
    }
}

