/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui;

import com.romraider.Settings;
import com.romraider.io.serial.port.SerialPortRefreshListener;
import com.romraider.util.ParamChecker;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerialPortComboBox
extends JComboBox
implements SerialPortRefreshListener {
    private static final long serialVersionUID = 5693976713268676676L;
    private final Settings settings;

    public SerialPortComboBox(Settings settings) {
        ParamChecker.checkNotNull(settings);
        this.settings = settings;
    }

    @Override
    public synchronized void refreshPortList(Set<String> set, String string) {
        boolean bl;
        ParamChecker.checkNotNull(set);
        boolean bl2 = bl = set.isEmpty() || set.size() != this.getItemCount();
        if (!bl) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                String string2 = (String)this.getItemAt(i);
                if (set.contains(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                TreeSet<String> treeSet = new TreeSet<String>();
                for (int i = 0; i < this.getItemCount(); ++i) {
                    treeSet.add((String)this.getItemAt(i));
                }
                for (String string3 : set) {
                    if (treeSet.contains(string3)) continue;
                    bl = true;
                    break;
                }
            }
        }
        if (bl) {
            String string4 = (String)this.getSelectedItem();
            if (string4 == null) {
                string4 = string;
            }
            this.removeAllItems();
            if (!set.isEmpty()) {
                for (String string3 : set) {
                    this.addItem(string3);
                }
                if (string4 != null && set.contains(string4)) {
                    this.setSelectedItem(string4);
                    this.settings.setLoggerPort(string4);
                } else {
                    this.setSelectedIndex(0);
                    this.settings.setLoggerPort((String)this.getItemAt(0));
                }
            }
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.contains(object)) {
            super.setSelectedItem(object);
        } else if (this.getItemCount() >= 1) {
            this.setSelectedIndex(0);
        }
    }

    private boolean contains(Object object) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getItemAt(i) == null || !this.getItemAt(i).equals(object)) continue;
            return true;
        }
        return false;
    }
}

