/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.external;

import com.romraider.logger.ecu.EcuLogger;
import com.romraider.logger.ecu.external.ExternalDataItem;
import com.romraider.logger.ecu.external.ExternalDataSource;
import com.romraider.logger.ecu.external.GenericDataSourceConnector;
import com.romraider.logger.ecu.ui.swing.menubar.action.GenericPluginMenuAction;
import com.romraider.util.ParamChecker;
import com.romraider.util.Stoppable;
import com.romraider.util.ThreadUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericDataSourceManager
implements ExternalDataSource {
    private static final Logger LOGGER = Logger.getLogger(GenericDataSourceManager.class);
    private final List<Stoppable> connectors = new ArrayList<Stoppable>();
    private final ExternalDataSource dataSource;
    private int connectCount;

    public GenericDataSourceManager(ExternalDataSource externalDataSource) {
        ParamChecker.checkNotNull((Object)externalDataSource, "dataSource");
        this.dataSource = externalDataSource;
    }

    @Override
    public String getName() {
        return this.dataSource.getName();
    }

    @Override
    public String getVersion() {
        return this.dataSource.getVersion();
    }

    @Override
    public List<? extends ExternalDataItem> getDataItems() {
        return this.dataSource.getDataItems();
    }

    @Override
    public Action getMenuAction(EcuLogger ecuLogger) {
        return new GenericPluginMenuAction(ecuLogger, this);
    }

    @Override
    public synchronized void setPort(String string) {
        String string2 = this.getPort();
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        LOGGER.info((Object)(this.dataSource.getName() + ": port " + string + " selected"));
        this.reconnect(string);
    }

    @Override
    public String getPort() {
        return this.dataSource.getPort();
    }

    @Override
    public synchronized void connect() {
        if (this.connectCount++ == 0) {
            this.doConnect();
        }
        LOGGER.trace((Object)("Connect count [" + this.dataSource.getName() + "]: " + this.connectCount));
    }

    @Override
    public synchronized void disconnect() {
        if (this.connectCount-- == 1) {
            this.doDisconnect();
        }
        if (this.connectCount < 0) {
            this.connectCount = 0;
        }
        LOGGER.trace((Object)("Connect count [" + this.dataSource.getName() + "]: " + this.connectCount));
    }

    private void doConnect() {
        GenericDataSourceConnector genericDataSourceConnector = new GenericDataSourceConnector(this.dataSource);
        this.connectors.add(genericDataSourceConnector);
        ThreadUtil.runAsDaemon(genericDataSourceConnector);
    }

    private void doDisconnect() {
        try {
            LOGGER.info((Object)(this.dataSource.getName() + ": disconnecting"));
            while (!this.connectors.isEmpty()) {
                this.connectors.remove(0).stop();
            }
            this.dataSource.disconnect();
        }
        catch (Exception exception) {
            LOGGER.error((Object)("External Datasource [" + this.dataSource.getName() + "] disconnect error"), (Throwable)exception);
        }
    }

    private void reconnect(String string) {
        this.dataSource.setPort(string);
        this.doDisconnect();
        this.doConnect();
    }
}

