/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition.xml;

import com.romraider.logger.ecu.definition.EcuDefinition;
import com.romraider.logger.ecu.definition.EcuDefinitionImpl;
import com.romraider.util.ParamChecker;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcuDefinitionHandler
extends DefaultHandler {
    private static final String TAG_ROMID = "romid";
    private static final String TAG_CALID = "internalidstring";
    private static final String TAG_ECUID = "ecuid";
    private Map<String, EcuDefinition> ecuDefinitionMap = new HashMap<String, EcuDefinition>();
    private String calId;
    private String ecuId;
    private StringBuilder charBuffer;

    @Override
    public void startDocument() {
        this.ecuDefinitionMap = new HashMap<String, EcuDefinition>();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (TAG_ROMID.equals(string3)) {
            this.calId = "";
            this.ecuId = "";
        }
        this.charBuffer = new StringBuilder();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.charBuffer.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (TAG_ROMID.equals(string3)) {
            if (!ParamChecker.isNullOrEmpty(this.ecuId) && !ParamChecker.isNullOrEmpty(this.calId)) {
                this.ecuDefinitionMap.put(this.ecuId, new EcuDefinitionImpl(this.ecuId, this.calId));
            }
        } else if (TAG_CALID.equals(string3)) {
            this.calId = this.charBuffer.toString();
        } else if (TAG_ECUID.equals(string3)) {
            this.ecuId = this.charBuffer.toString();
        }
    }

    public Map<String, EcuDefinition> getEcuDefinitionMap() {
        return this.ecuDefinitionMap;
    }
}

