/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.ConvertorUpdateListener;
import com.romraider.logger.ecu.definition.EcuAddress;
import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuDataType;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.util.ParamChecker;
import java.util.HashSet;
import java.util.Set;

public final class EcuParameterImpl
implements EcuParameter {
    private final String id;
    private final String name;
    private final String description;
    private final EcuAddress address;
    private final EcuDataConvertor[] convertors;
    private final Set<ConvertorUpdateListener> listeners = new HashSet<ConvertorUpdateListener>();
    private int selectedConvertorIndex;
    private boolean selected;

    public EcuParameterImpl(String string, String string2, String string3, EcuAddress ecuAddress, EcuDataConvertor[] ecuDataConvertorArray) {
        ParamChecker.checkNotNullOrEmpty(string2, "id");
        ParamChecker.checkNotNullOrEmpty(string2, "name");
        ParamChecker.checkNotNull((Object)string3, "description");
        ParamChecker.checkNotNull((Object)ecuAddress, "address");
        ParamChecker.checkNotNullOrEmpty(ecuDataConvertorArray, "convertors");
        this.id = string;
        this.name = string2;
        this.description = string3;
        this.address = ecuAddress;
        this.convertors = ecuDataConvertorArray;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EcuAddress getAddress() {
        return this.address;
    }

    public EcuDataConvertor getSelectedConvertor() {
        return this.convertors[this.selectedConvertorIndex];
    }

    public EcuDataConvertor[] getConvertors() {
        return this.convertors;
    }

    public void selectConvertor(EcuDataConvertor ecuDataConvertor) {
        if (ecuDataConvertor != this.getSelectedConvertor()) {
            for (int i = 0; i < this.convertors.length; ++i) {
                EcuDataConvertor ecuDataConvertor2 = this.convertors[i];
                if (ecuDataConvertor != ecuDataConvertor2) continue;
                this.selectedConvertorIndex = i;
            }
            this.notifyUpdateListeners();
        }
    }

    public EcuDataType getDataType() {
        return EcuDataType.PARAMETER;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void addConvertorUpdateListener(ConvertorUpdateListener convertorUpdateListener) {
        ParamChecker.checkNotNull((Object)convertorUpdateListener, "listener");
        this.listeners.add(convertorUpdateListener);
    }

    private void notifyUpdateListeners() {
        for (ConvertorUpdateListener convertorUpdateListener : this.listeners) {
            convertorUpdateListener.notifyConvertorUpdate(this);
        }
    }
}

