/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.definition;

import com.romraider.logger.ecu.definition.ConvertorUpdateListener;
import com.romraider.logger.ecu.definition.EcuAddress;
import com.romraider.logger.ecu.definition.EcuAddressImpl;
import com.romraider.logger.ecu.definition.EcuData;
import com.romraider.logger.ecu.definition.EcuDataConvertor;
import com.romraider.logger.ecu.definition.EcuDataType;
import com.romraider.logger.ecu.definition.EcuDerivedParameterConvertor;
import com.romraider.logger.ecu.definition.EcuParameter;
import com.romraider.util.ParamChecker;
import java.util.HashSet;
import java.util.Set;

public final class EcuDerivedParameterImpl
implements EcuParameter {
    private final String id;
    private final String name;
    private final String description;
    private final EcuDerivedParameterConvertor[] convertors;
    private final EcuAddress address;
    private final Set<ConvertorUpdateListener> listeners = new HashSet<ConvertorUpdateListener>();
    private int selectedConvertorIndex;
    private boolean selected;

    public EcuDerivedParameterImpl(String string, String string2, String string3, EcuData[] ecuDataArray, EcuDerivedParameterConvertor[] ecuDerivedParameterConvertorArray) {
        ParamChecker.checkNotNullOrEmpty(string2, "id");
        ParamChecker.checkNotNullOrEmpty(string2, "name");
        ParamChecker.checkNotNull((Object)string3, "description");
        ParamChecker.checkNotNullOrEmpty(ecuDataArray, "ecuDatas");
        ParamChecker.checkNotNullOrEmpty(ecuDerivedParameterConvertorArray, "convertors");
        this.id = string;
        this.name = string2;
        this.description = string3;
        this.convertors = ecuDerivedParameterConvertorArray;
        this.address = this.buildCombinedAddress(ecuDataArray);
        this.setEcuDatas(ecuDataArray);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EcuAddress getAddress() {
        return this.address;
    }

    public EcuDataConvertor getSelectedConvertor() {
        return this.convertors[this.selectedConvertorIndex];
    }

    public EcuDataConvertor[] getConvertors() {
        return this.convertors;
    }

    public void selectConvertor(EcuDataConvertor ecuDataConvertor) {
        if (ecuDataConvertor != this.getSelectedConvertor()) {
            for (int i = 0; i < this.convertors.length; ++i) {
                EcuDerivedParameterConvertor ecuDerivedParameterConvertor = this.convertors[i];
                if (ecuDataConvertor != ecuDerivedParameterConvertor) continue;
                this.selectedConvertorIndex = i;
            }
            this.notifyUpdateListeners();
        }
    }

    public EcuDataType getDataType() {
        return EcuDataType.PARAMETER;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void addConvertorUpdateListener(ConvertorUpdateListener convertorUpdateListener) {
        ParamChecker.checkNotNull((Object)convertorUpdateListener, "listener");
        this.listeners.add(convertorUpdateListener);
    }

    private EcuAddress buildCombinedAddress(EcuData[] ecuDataArray) {
        String[] stringArray = new String[]{};
        for (EcuData ecuData : ecuDataArray) {
            String[] stringArray2 = ecuData.getAddress().getAddresses();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            stringArray = stringArray3;
        }
        return new EcuAddressImpl(stringArray);
    }

    private void setEcuDatas(EcuData[] ecuDataArray) {
        for (EcuDerivedParameterConvertor ecuDerivedParameterConvertor : this.convertors) {
            ecuDerivedParameterConvertor.setEcuDatas(ecuDataArray);
        }
    }

    private void notifyUpdateListeners() {
        for (ConvertorUpdateListener convertorUpdateListener : this.listeners) {
            convertorUpdateListener.notifyConvertorUpdate(this);
        }
    }
}

