/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.comms.io.protocol;

import com.romraider.io.protocol.Protocol;
import com.romraider.io.protocol.ssm.SSMProtocol;
import com.romraider.io.protocol.ssm.SSMResponseProcessor;
import com.romraider.logger.ecu.comms.io.protocol.LoggerProtocol;
import com.romraider.logger.ecu.comms.query.EcuInit;
import com.romraider.logger.ecu.comms.query.EcuInitCallback;
import com.romraider.logger.ecu.comms.query.EcuQuery;
import com.romraider.util.ParamChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSMLoggerProtocol
implements LoggerProtocol {
    private final Protocol protocol = new SSMProtocol();

    @Override
    public byte[] constructEcuInitRequest() {
        return this.protocol.constructEcuInitRequest();
    }

    @Override
    public byte[] constructEcuResetRequest() {
        return this.protocol.constructEcuResetRequest();
    }

    @Override
    public byte[] constructReadAddressRequest(Collection<EcuQuery> collection) {
        Collection<EcuQuery> collection2 = this.filterDuplicates(collection);
        return this.protocol.constructReadAddressRequest(this.convertToByteAddresses(collection2));
    }

    @Override
    public byte[] constructReadAddressResponse(Collection<EcuQuery> collection) {
        ParamChecker.checkNotNullOrEmpty(collection, "queries");
        Collection<EcuQuery> collection2 = this.filterDuplicates(collection);
        int n = 0;
        for (EcuQuery ecuQuery : collection2) {
            n += ecuQuery.getBytes().length / 3;
        }
        return new byte[n * 1 + 6 + (n * 3 + 7)];
    }

    @Override
    public byte[] preprocessResponse(byte[] byArray, byte[] byArray2) {
        return SSMResponseProcessor.filterRequestFromResponse(byArray, byArray2);
    }

    @Override
    public void processEcuInitResponse(EcuInitCallback ecuInitCallback, byte[] byArray) {
        ParamChecker.checkNotNull((Object)ecuInitCallback, "callback");
        ParamChecker.checkNotNullOrEmpty(byArray, "response");
        this.protocol.checkValidEcuInitResponse(byArray);
        EcuInit ecuInit = this.protocol.parseEcuInitResponse(byArray);
        ecuInitCallback.callback(ecuInit);
    }

    @Override
    public void processEcuResetResponse(byte[] byArray) {
        ParamChecker.checkNotNullOrEmpty(byArray, "response");
        this.protocol.checkValidEcuResetResponse(byArray);
    }

    @Override
    public void processReadAddressResponses(Collection<EcuQuery> collection, byte[] byArray) {
        ParamChecker.checkNotNullOrEmpty(collection, "queries");
        ParamChecker.checkNotNullOrEmpty(byArray, "response");
        byte[] byArray2 = SSMResponseProcessor.extractResponseData(byArray);
        Collection<EcuQuery> collection2 = this.filterDuplicates(collection);
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        int n = 0;
        for (EcuQuery ecuQuery : collection2) {
            byte[] byArray3 = new byte[1 * (ecuQuery.getBytes().length / 3)];
            System.arraycopy(byArray2, n, byArray3, 0, byArray3.length);
            hashMap.put(ecuQuery.getHex(), byArray3);
            n += byArray3.length;
        }
        for (EcuQuery ecuQuery : collection) {
            ecuQuery.setResponse((byte[])hashMap.get(ecuQuery.getHex()));
        }
    }

    private Collection<EcuQuery> filterDuplicates(Collection<EcuQuery> collection) {
        ArrayList<EcuQuery> arrayList = new ArrayList<EcuQuery>();
        for (EcuQuery ecuQuery : collection) {
            if (arrayList.contains(ecuQuery)) continue;
            arrayList.add(ecuQuery);
        }
        return arrayList;
    }

    private byte[][] convertToByteAddresses(Collection<EcuQuery> collection) {
        int n = 0;
        for (EcuQuery ecuQuery : collection) {
            n += ecuQuery.getAddresses().length;
        }
        Object object = new byte[n][3];
        int n2 = 0;
        for (EcuQuery ecuQuery : collection) {
            byte[] byArray = ecuQuery.getBytes();
            for (int i = 0; i < byArray.length / 3; ++i) {
                System.arraycopy(byArray, i * 3, object[n2++], 0, 3);
            }
        }
        return object;
    }
}

