/*
 * Decompiled with CFR 0.152.
 */
package com.romraider;

import com.centerkey.utils.BareBonesBrowserLaunch;
import com.romraider.Settings;
import com.romraider.logger.ecu.ui.handler.table.TableUpdateHandler;
import com.romraider.maps.Rom;
import com.romraider.maps.Table;
import com.romraider.net.URL;
import com.romraider.swing.ECUEditorMenuBar;
import com.romraider.swing.ECUEditorToolBar;
import com.romraider.swing.JProgressPane;
import com.romraider.swing.MDIDesktopPane;
import com.romraider.swing.RomTree;
import com.romraider.swing.RomTreeNode;
import com.romraider.swing.RomTreeRootNode;
import com.romraider.swing.TableFrame;
import com.romraider.util.SettingsManager;
import com.romraider.util.SettingsManagerImpl;
import com.romraider.xml.DOMRomUnmarshaller;
import com.romraider.xml.RomNotFoundException;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECUEditor
extends JFrame
implements WindowListener,
PropertyChangeListener {
    private static final long serialVersionUID = -7826850987392016292L;
    private String titleText = "RomRaider v0.5.2 Beta  | ECU Editor";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final SettingsManager settingsManager = new SettingsManagerImpl();
    private RomTreeRootNode imageRoot = new RomTreeRootNode("Open Images");
    private RomTree imageList = new RomTree(this.imageRoot);
    public MDIDesktopPane rightPanel = new MDIDesktopPane();
    private JProgressPane statusPanel = new JProgressPane();
    private JSplitPane splitPane = new JSplitPane();
    private Rom lastSelectedRom = null;
    private ECUEditorToolBar toolBar;
    private ECUEditorMenuBar menuBar;
    private Settings settings = this.settingsManager.load();

    public ECUEditor() {
        if (!this.settings.getRecentVersion().equalsIgnoreCase("0.5.2 Beta ")) {
            this.showReleaseNotes();
        }
        this.setSize(this.getSettings().getWindowSize());
        this.setLocation(this.getSettings().getWindowLocation());
        if (this.getSettings().isWindowMaximized()) {
            this.setExtendedState(6);
        }
        JScrollPane jScrollPane = new JScrollPane(this.rightPanel, 20, 30);
        JScrollPane jScrollPane2 = new JScrollPane(this.imageList, 20, 30);
        this.splitPane = new JSplitPane(1, jScrollPane2, jScrollPane);
        this.splitPane.setDividerSize(3);
        this.splitPane.setDividerLocation(this.getSettings().getSplitPaneLocation());
        this.splitPane.addPropertyChangeListener(this);
        this.getContentPane().add(this.splitPane);
        this.rightPanel.setBackground(Color.BLACK);
        this.imageList.setScrollsOnExpand(true);
        this.imageList.setContainer(this);
        this.menuBar = new ECUEditorMenuBar(this);
        this.setJMenuBar(this.menuBar);
        this.toolBar = new ECUEditorToolBar(this);
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.statusPanel, "South");
        this.setIconImage(new ImageIcon("./graphics/romraider-ico.gif").getImage());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(this);
        this.setTitle(this.titleText);
        this.setVisible(true);
        if (this.settings.getEcuDefinitionFiles().size() <= 0) {
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(null, "ECU definitions not configured.\nGo online to download the latest definition files?", "Editor Configuration", -1, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                BareBonesBrowserLaunch.openURL("http://www.romraider.com/forum/topic360.html");
            } else {
                JOptionPane.showMessageDialog(this, "ECU definition files need to be configured before ROM images can be opened.\nMenu: ECU Definitions > ECU Definition Manager...", "Editor Configuration", 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showReleaseNotes() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.settings.getReleaseNotes()));
            try {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setEditable(false);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setLineWrap(true);
                jTextArea.setFont(new Font("Tahoma", 0, 12));
                JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 31);
                jScrollPane.setPreferredSize(new Dimension(600, 500));
                StringBuffer stringBuffer = new StringBuffer();
                while (bufferedReader.ready()) {
                    stringBuffer.append(bufferedReader.readLine()).append(NEW_LINE);
                }
                jTextArea.setText(stringBuffer.toString());
                JOptionPane.showMessageDialog(this, jScrollPane, "RomRaider0.5.2 Beta  Release Notes", 1);
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleExit() {
        this.settings.setSplitPaneLocation(this.splitPane.getDividerLocation());
        this.settings.setWindowMaximized(this.getExtendedState() == 6);
        this.settings.setWindowSize(this.getSize());
        this.settings.setWindowLocation(this.getLocation());
        this.settingsManager.save(this.settings, this.statusPanel);
        this.statusPanel.update("Ready...", 0);
        this.repaint();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.handleExit();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public String getVersion() {
        return "0.5.2 Beta ";
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void addRom(Rom rom) {
        RomTreeNode romTreeNode = new RomTreeNode(rom, this.settings.getUserLevel(), this.settings.isDisplayHighTables());
        this.imageRoot.add(romTreeNode);
        this.imageList.updateUI();
        this.imageList.expandRow(this.imageList.getRowCount() - 1);
        this.imageList.updateUI();
        this.setLastSelectedRom(rom);
        if (rom.getRomID().isObsolete() && this.settings.isObsoleteWarning()) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(3, 1));
            jPanel.add(new JLabel("A newer version of this ECU revision exists. Please visit the following link to download the latest revision:"));
            jPanel.add(new URL(this.settings.getRomRevisionURL()));
            JCheckBox jCheckBox = new JCheckBox("Always display this message", true);
            jCheckBox.setHorizontalAlignment(4);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ECUEditor.this.settings.setObsoleteWarning(((JCheckBox)actionEvent.getSource()).isSelected());
                }
            });
            jPanel.add(jCheckBox);
            JOptionPane.showMessageDialog(this, jPanel, "ECU Revision is Obsolete", 1);
        }
        rom.setContainer(this);
        this.imageList.updateUI();
    }

    public void displayTable(TableFrame tableFrame) {
        tableFrame.setVisible(true);
        try {
            this.rightPanel.add(tableFrame);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            tableFrame.requestFocus();
        }
        tableFrame.pack();
        this.rightPanel.repaint();
    }

    public void removeDisplayTable(TableFrame tableFrame) {
        tableFrame.setVisible(false);
        this.rightPanel.remove(tableFrame);
        this.rightPanel.repaint();
    }

    public void closeImage() {
        for (int i = 0; i < this.imageRoot.getChildCount(); ++i) {
            RomTreeNode romTreeNode = (RomTreeNode)this.imageRoot.getChildAt(i);
            Rom rom = romTreeNode.getRom();
            if (rom != this.lastSelectedRom) continue;
            Vector<Table> vector = rom.getTables();
            for (Table table : vector) {
                this.rightPanel.remove(table.getFrame());
                TableUpdateHandler.getInstance().deregisterTable(table);
            }
            Vector vector2 = new Vector();
            vector2.add(new TreePath(romTreeNode.getPath()));
            this.imageRoot.remove(i);
            this.imageList.removeDescendantToggledPaths(vector2.elements());
            break;
        }
        this.imageList.updateUI();
        if (this.imageRoot.getChildCount() > 0) {
            this.setLastSelectedRom(((RomTreeNode)this.imageRoot.getChildAt(0)).getRom());
        } else {
            this.setLastSelectedRom(null);
        }
        this.rightPanel.repaint();
    }

    public void closeAllImages() {
        while (this.imageRoot.getChildCount() > 0) {
            this.closeImage();
        }
    }

    public Rom getLastSelectedRom() {
        return this.lastSelectedRom;
    }

    public void setLastSelectedRom(Rom rom) {
        this.lastSelectedRom = rom;
        if (rom == null) {
            this.setTitle(this.titleText);
        } else {
            this.setTitle(this.titleText + " - " + rom.getFileName());
        }
        for (int i = 0; i < this.imageRoot.getChildCount(); ++i) {
            ((RomTreeNode)this.imageRoot.getChildAt(i)).updateFileName();
        }
        this.toolBar.updateButtons();
        this.menuBar.updateMenu();
        this.imageList.updateUI();
    }

    public ECUEditorToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(ECUEditorToolBar eCUEditorToolBar) {
        this.toolBar = eCUEditorToolBar;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        for (int i = 0; i < this.imageRoot.getChildCount(); ++i) {
            RomTreeNode romTreeNode = (RomTreeNode)this.imageRoot.getChildAt(i);
            romTreeNode.getRom().setContainer(this);
        }
    }

    public void setUserLevel(int n) {
        this.settings.setUserLevel(n);
        this.imageRoot.setUserLevel(n, this.settings.isDisplayHighTables());
        this.imageList.updateUI();
    }

    public Vector<Rom> getImages() {
        Vector<Rom> vector = new Vector<Rom>();
        for (int i = 0; i < this.imageRoot.getChildCount(); ++i) {
            RomTreeNode romTreeNode = (RomTreeNode)this.imageRoot.getChildAt(i);
            vector.add(romTreeNode.getRom());
        }
        return vector;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.imageList.updateUI();
        this.imageList.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openImage(File file) throws Exception {
        try {
            this.update(this.getGraphics());
            this.statusPanel.update("Parsing ECU definitions...", 0);
            this.repaint();
            byte[] byArray = this.readFile(file);
            DOMRomUnmarshaller dOMRomUnmarshaller = new DOMRomUnmarshaller(this.settings, this);
            DOMParser dOMParser = new DOMParser();
            this.statusPanel.update("Finding ECU definition...", 10);
            this.repaint();
            for (int i = 0; i < this.settings.getEcuDefinitionFiles().size(); ++i) {
                InputSource inputSource = new InputSource(new FileInputStream(this.settings.getEcuDefinitionFiles().get(i)));
                dOMParser.parse(inputSource);
                Document document = dOMParser.getDocument();
                try {
                    Rom rom = dOMRomUnmarshaller.unmarshallXMLDefinition(document.getDocumentElement(), byArray, this.statusPanel);
                    this.statusPanel.update("Populating tables...", 50);
                    this.repaint();
                    rom.populateTables(byArray, this.statusPanel);
                    rom.setFileName(file.getName());
                    this.statusPanel.update("Finalizing...", 90);
                    this.repaint();
                    this.addRom(rom);
                    rom.setFullFileName(file);
                    return;
                }
                catch (RomNotFoundException romNotFoundException) {
                    continue;
                }
            }
            JOptionPane.showMessageDialog(this, "ECU Definition Not Found", "Error Loading " + file.getName(), 0);
        }
        catch (StackOverflowError stackOverflowError) {
            JOptionPane.showMessageDialog(this, "Looped \"base\" attribute in XML definitions.", "Error Loading ROM", 0);
        }
        finally {
            this.statusPanel.update("Ready...", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            fileInputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

