package cerot.blight.btrace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.sun.btrace.CommandListener;
import com.sun.btrace.client.Client;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.DataCommand;
import com.sun.btrace.comm.MessageCommand;

public class MemoryCommandListener implements CommandListener {
	private Client client;

	private List<DataCommand> commandList = new ArrayList<DataCommand>();
	private List<MessageCommand> messageList = new ArrayList<MessageCommand>();

	public MemoryCommandListener(Client client) {
		this.client = client;
	}

	@Override
	public void onCommand(Command command) throws IOException {
		byte type = command.getType();
		if (type == Command.SUCCESS) {
			System.out.println("Start trace");
		} else if (type == Command.MESSAGE) {
			messageList.add((MessageCommand) command);
		} else if (type == Command.GRID_DATA || type == Command.NUMBER_MAP
				|| type == Command.STRING_MAP) {
			commandList.add((DataCommand) command);
		} else if (type == Command.EXIT) {
			client.close();
		}
	}

	public List<MessageCommand> getMessageList() {
		return this.messageList;
	}

	public List<DataCommand> getCommandList() {
		return this.commandList;
	}
}
