package cerot.blight.btrace;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;

import com.sun.btrace.client.Client;
import com.sun.btrace.comm.MessageCommand;
import com.sun.btrace.compiler.Compiler;

public class BTraceController {
	private static final String TARGET_CLASS = "/tutorial\\..*/";
	private static final String TARGET_METHOD = "/.*/";
	private static final int DEFAULT_PORT = 2020;
	private Client client;
	private MemoryCommandListener listener;

	public void beginTrace(String pid) throws Exception {
		String source = readResource("/Trace.txt");
		source = source.replaceAll("%CLASS_NAME%", TARGET_CLASS);
		source = source.replaceAll("%METHOD_NAME%", TARGET_METHOD);

		com.sun.btrace.compiler.Compiler compiler = new Compiler();
		Map<String, byte[]> classMap = compiler.compile("Trace.java", source,
				new OutputStreamWriter(System.err), null, null);

		client = new Client(DEFAULT_PORT);
		client.attach(pid);
		listener = new MemoryCommandListener(client);
		client.submit(classMap.get("Trace"), new String[0], listener);
	}

	public void stopTrace() throws IOException {
		this.client.sendExit();
	}

	public List<MethodExpression> getResult() {
		List<MessageCommand> messageList = this.listener.getMessageList();
		List<MethodExpression> result = BTraceConverter
				.toMethodExpressionList(messageList);

		// TODO: debug code
		for (MethodExpression methodExpression : result) {
			System.out.println(methodExpression);
		}

		return result;
	}

	private String readResource(String resourceName) throws IOException {
		InputStream is = null;
		try {
			is = BTraceController.class.getResourceAsStream(resourceName);
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					is, "UTF-8"));
			StringBuilder builder = new StringBuilder();
			String line = null;
			while ((line = reader.readLine()) != null) {
				builder.append(line + "\n");
			}

			return new String(builder);
		} finally {
			if (is != null) {
				is.close();
			}
		}
	}
}
