/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FieldAccessInstrumentor
extends MethodInstrumentor {
    public FieldAccessInstrumentor(MethodVisitor mv, int access, String name, String desc) {
        super(mv, access, name, desc);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        boolean get = opcode == 180 || opcode == 178;
        if (get) {
            this.onBeforeGetField(opcode, owner, name, desc);
        } else {
            this.onBeforePutField(opcode, owner, name, desc);
        }
        super.visitFieldInsn(opcode, owner, name, desc);
        if (get) {
            this.onAfterGetField(opcode, owner, name, desc);
        } else {
            this.onAfterPutField(opcode, owner, name, desc);
        }
    }

    protected void onBeforeGetField(int opcode, String owner, String name, String desc) {
        this.println("before get: " + owner + "." + name);
    }

    protected void onAfterGetField(int opcode, String owner, String name, String desc) {
        this.println("after get: " + owner + "." + name);
    }

    protected void onBeforePutField(int opcode, String owner, String name, String desc) {
        this.println("before put: " + owner + "." + name);
    }

    protected void onAfterPutField(int opcode, String owner, String name, String desc) {
        this.println("after put: " + owner + "." + name);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.FieldAccessInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new FieldAccessInstrumentor(mv, access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

