/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ArrayAccessInstrumentor
extends MethodInstrumentor {
    public ArrayAccessInstrumentor(MethodVisitor mv, int access, String name, String desc) {
        super(mv, access, name, desc);
    }

    @Override
    public void visitInsn(int opcode) {
        boolean arrayload = false;
        boolean arraystore = false;
        switch (opcode) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                arrayload = true;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                arraystore = true;
            }
        }
        if (arrayload) {
            this.onBeforeArrayLoad(opcode);
        } else if (arraystore) {
            this.onBeforeArrayStore(opcode);
        }
        super.visitInsn(opcode);
        if (arrayload) {
            this.onAfterArrayLoad(opcode);
        } else if (arraystore) {
            this.onAfterArrayStore(opcode);
        }
    }

    protected void onBeforeArrayLoad(int opcode) {
        this.println("before array load");
    }

    protected void onAfterArrayLoad(int opcode) {
        this.println("after array load");
    }

    protected void onBeforeArrayStore(int opcode) {
        this.println("before array store");
    }

    protected void onAfterArrayStore(int opcode) {
        this.println("after array store");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.ArrayAccessInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new ArrayAccessInstrumentor(mv, access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

