package cerot.tools.taskmine;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.xml.bind.JAXBException;

import cerot.tools.redmine.timelog.accessor.RedmineAccessor;
import cerot.tools.redmine.timelog.entity.TimeEntry;
import cerot.tools.taskcoach.entity.Tasks;
import cerot.tools.taskcoach.util.TaskParser;
import cerot.tools.taskmine.converter.TaskConverter;

/**
 * TaskCoachの経過時間をRedmineに投入するメインクラス。
 * @author cero-t
 * 
 */
public final class TimeTracker {
	/**
	 * TaskCoachの経過時間をRedmineに投入します。
	 * @param args ファイル名
	 * @throws JAXBException 引数に指定されたファイルを正常に解析できない場合
	 * @throws IOException Redmineへのアクセスに失敗した場合
	 */
	public static void main(String[] args) throws JAXBException, IOException {
		File file = new File(args[0]);
		Tasks tasks = TaskParser.read(file);
		List<TimeEntry> timeEntryList = TaskConverter.toTimeEntry(tasks);
		RedmineAccessor accessor = new RedmineAccessor();
		accessor.trackTime(timeEntryList);
	}

	/**
	 * プライベートコンストラクタ。呼び出し禁止。
	 */
	private TimeTracker() {
		// Do Nothing.
	}
}
