package cerot.tools.taskcoach.util;

import java.util.ArrayList;
import java.util.List;

import cerot.tools.taskcoach.entity.Task;
import cerot.tools.taskcoach.entity.Tasks;

/**
 * タスクを扱うためのユーティリティクラス。
 * @author cero-t
 * 
 */
public final class TaskUtils {
	/**
	 * 子タスクを再帰的に取得して、リストとして返します。
	 * @param tasks タスクのルートモデル
	 * @return タスクのリスト。
	 */
	public static List<Task> extractTask(Tasks tasks) {
		if (tasks.taskList == null) {
			return new ArrayList<Task>();
		}

		List<Task> result = extractTask(tasks.taskList);
		return result;
	}

	/**
	 * タスクの子タスクを再帰的に取得して、リストとして返します。
	 * @param taskList タスクのリスト。nullでないこと。
	 * @return タスクのリスト。引数のタスクを含みます。
	 */
	public static List<Task> extractTask(List<Task> taskList) {
		List<Task> result = new ArrayList<Task>();

		for (Task task : taskList) {
			result.add(task);

			if (task.taskList != null) {
				List<Task> childList = extractTask(task.taskList);
				result.addAll(childList);
			}
		}

		return result;
	}

	/**
	 * プライベートコンストラクタ。呼び出し禁止。
	 */
	private TaskUtils() {
		// Do Nothing.
	}
}
