package cerot.tools.taskcoach.util;

import java.io.File;
import java.io.InputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import cerot.tools.taskcoach.entity.Tasks;

/**
 * タスクファイルの解析を行うクラス。
 * @author cero-t
 * 
 */
public final class TaskParser {
	/** JAXBContext */
	private static final JAXBContext CONTEXT;

	static {
		JAXBContext context = null;
		try {
			context = JAXBContext.newInstance(Tasks.class);
		} catch (JAXBException ex) {
			ex.printStackTrace();
		}
		CONTEXT = context;
	}

	/**
	 * タスクファイルを解析します。
	 * @param file タスクファイル
	 * @return タスクのルートモデル
	 * @throws JAXBException タスクファイルのXML解析に失敗した場合
	 */
	public static Tasks read(File file) throws JAXBException {
		Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
		return (Tasks) unmarshaller.unmarshal(file);
	}

	/**
	 * タスクファイルを解析します。
	 * @param in タスクファイルのストリーム
	 * @return タスクのルートモデル
	 * @throws JAXBException タスクファイルのXML解析に失敗した場合
	 */
	public static Tasks read(InputStream in) throws JAXBException {
		Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
		return (Tasks) unmarshaller.unmarshal(in);
	}

	/**
	 * プライベートコンストラクタ。呼び出し禁止。
	 */
	private TaskParser() {
		// Do Nothing.
	}
}
