package cerot.tools.redmine.timelog.accessor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

/**
 * 経過時間入力フォームのレスポンスハンドラクラス。
 * @author cero-t
 * 
 */
public class TimelogFormResponseHandler implements ResponseHandler<String> {
	/** フォームの開始文字列 */
	private static final String FORM_START = "<form action=\"";

	/** フォームの終了文字列 */
	private static final String FORM_END = "\" class=\"tabular\" method=\"post\">";

	/**
	 * {@inheritDoc}<br>
	 * 経過時間登録用のパスを返します。
	 */
	@Override
	public String handleResponse(HttpResponse response) throws IOException {
		HttpEntity entity = response.getEntity();
		if (entity == null) {
			return null;
		}

		BufferedReader reader = null;
		InputStream in = entity.getContent();
		try {
			reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));

			String line = null;
			while ((line = reader.readLine()) != null) {
				if (line.startsWith(FORM_START) && line.endsWith(FORM_END)) {
					String path = line.substring(FORM_START.length(), line
							.indexOf(FORM_END));
					return path;
				}
			}
		} finally {
			if (reader != null) {
				reader.close();
			} else {
				in.close();
			}
		}

		return null;
	}
}
