package cerot.blight.btrace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.sun.btrace.CommandListener;
import com.sun.btrace.client.Client;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.DataCommand;
import com.sun.btrace.comm.MessageCommand;

/**
 * BTraceクライアントコマンドのリスナークラス。
 * @author cero-t
 * 
 */
public class MemoryCommandListener implements CommandListener {
	/** BTraceクライアント */
	private Client client;

	/** メッセージコマンドのリスト */
	private List<MessageCommand> messageList = new ArrayList<MessageCommand>();

	/** メッセージ以外のデータコマンドのリスト */
	private List<DataCommand> commandList = new ArrayList<DataCommand>();

	/**
	 * コンストラクタ。BTraceクライアントを設定します。
	 * @param client BTraceクライアント
	 */
	public MemoryCommandListener(Client client) {
		this.client = client;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void onCommand(Command command) throws IOException {
		byte type = command.getType();
		if (type == Command.SUCCESS) {
			System.out.println("Start trace");
		} else if (type == Command.MESSAGE) {
			this.messageList.add((MessageCommand) command);
		} else if (type == Command.GRID_DATA || type == Command.NUMBER_MAP
				|| type == Command.STRING_MAP) {
			this.commandList.add((DataCommand) command);
		} else if (type == Command.EXIT) {
			this.client.close();
		}
	}

	/**
	 * メッセージコマンドのリストを取得します。
	 * @return メッセージコマンドのリスト
	 */
	public List<MessageCommand> getMessageList() {
		return this.messageList;
	}

	/**
	 * メッセージ以外のデータコマンドのリストを取得します。
	 * @return メッセージ以外のデータコマンドのリスト
	 */
	public List<DataCommand> getCommandList() {
		return this.commandList;
	}
}
