/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLightweightTextPane;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class mxUtils {
    protected static transient Graphics fontGraphics;

    public static mxRectangle getLabelSize(String string, Hashtable hashtable, boolean bl) {
        mxRectangle mxRectangle2;
        if (bl) {
            mxRectangle2 = mxUtils.getSizeForHtml(mxUtils.getBodyMarkup(string, true), hashtable);
        } else {
            float f = mxUtils.getFloat(hashtable, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE);
            String string2 = mxUtils.getString(hashtable, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILY);
            int n = mxUtils.getInt(hashtable, mxConstants.STYLE_FONTSTYLE);
            mxRectangle2 = mxUtils.getSizeForString(string, f, string2, n);
        }
        return mxRectangle2;
    }

    public static String getBodyMarkup(String string, boolean bl) {
        int n;
        String string2 = string.toLowerCase();
        int n2 = string2.indexOf("<body>");
        if (n2 >= 0 && (n = string2.lastIndexOf("</body>")) > (n2 += 7)) {
            string = string.substring(n2, n).trim();
        }
        if (bl) {
            string = string.replaceAll("\n", "<br>");
        }
        return string;
    }

    public static mxRectangle getScaledLabelBounds(double d, double d2, mxRectangle mxRectangle2, double d3, double d4, Hashtable hashtable, double d5) {
        double d6 = (double)mxConstants.LABEL_INSET * d5;
        double d7 = mxRectangle2.getWidth() * d5 + 2.0 * d6;
        double d8 = mxRectangle2.getHeight() * d5 + 2.0 * d6;
        boolean bl = mxUtils.isTrue(hashtable, mxConstants.STYLE_HORIZONTAL, true);
        int n = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_SPACING) * d5);
        String string = mxUtils.getString(hashtable, mxConstants.STYLE_ALIGN, "center");
        String string2 = mxUtils.getString(hashtable, mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        int n2 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_SPACING_TOP) * d5);
        int n3 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_SPACING_BOTTOM) * d5);
        int n4 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_SPACING_LEFT) * d5);
        int n5 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_SPACING_RIGHT) * d5);
        if (!bl) {
            int n6 = n2;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n6;
            double d9 = d7;
            d7 = d8;
            d8 = d9;
        }
        d = bl && string.equals("center") || !bl && string2.equals("middle") ? (d += (d3 - d7) / 2.0 + (double)n4 - (double)n5) : (bl && string.equals("right") || !bl && string2.equals("bottom") ? (d += d3 - d7 - (double)n - (double)n5) : (d += (double)(n + n4)));
        d2 = !bl && string.equals("center") || bl && string2.equals("middle") ? (d2 += (d4 - d8) / 2.0 + (double)n2 - (double)n3) : (!bl && string.equals("left") || bl && string2.equals("bottom") ? (d2 += d4 - d8 - (double)n - (double)n3) : (d2 += (double)(n + n2)));
        return new mxRectangle(d, d2, d7, d8);
    }

    public static mxRectangle getSizeForString(String string) {
        return mxUtils.getSizeForString(string, 0.0f);
    }

    public static mxRectangle getSizeForString(String string, float f) {
        return mxUtils.getSizeForString(string, f, null);
    }

    public static mxRectangle getSizeForString(String string, float f, String string2) {
        return mxUtils.getSizeForString(string, f, string2, 0);
    }

    public static mxRectangle getSizeForString(String string, float f, String string2, int n) {
        if (f == 0.0f) {
            f = mxConstants.DEFAULT_FONTSIZE;
        }
        if (string2 == null) {
            string2 = mxConstants.DEFAULT_FONTFAMILY;
        }
        int n2 = (n & 1) == 1 ? 1 : 0;
        int n3 = (n & 2) == 2 ? 2 : 0;
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Font font = new Font(string2, n2 += n3, (int)f);
        FontMetrics fontMetrics = null;
        if (fontGraphics != null) {
            fontMetrics = fontGraphics.getFontMetrics(font);
        }
        double d = mxConstants.LINESPACING;
        d = fontMetrics != null ? (d += (double)fontMetrics.getHeight()) : (d += (double)f * 1.27);
        String[] stringArray = string.split("\n");
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < stringArray.length; ++i) {
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, stringArray[i]);
            Rectangle2D rectangle2D2 = glyphVector.getVisualBounds();
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.setFrame(0.0, 0.0, Math.max(rectangle2D.getWidth(), rectangle2D2.getWidth()), rectangle2D.getHeight() + d);
        }
        return new mxRectangle(rectangle2D);
    }

    public static mxRectangle getSizeForHtml(String string, Hashtable hashtable) {
        mxLightweightTextPane mxLightweightTextPane2 = mxLightweightTextPane.getSharedInstance();
        if (mxLightweightTextPane2 != null) {
            mxLightweightTextPane2.setStyledDocument(mxUtils.createHtmlDocument(hashtable));
            mxLightweightTextPane2.setText(string);
            Dimension dimension = mxLightweightTextPane2.getPreferredSize();
            return new mxRectangle(0.0, 0.0, dimension.width, dimension.height);
        }
        return mxUtils.getSizeForString(string);
    }

    public static mxRectangle getBoundingBox(mxRectangle mxRectangle2, double d) {
        mxRectangle mxRectangle3 = null;
        if (mxRectangle2 != null && d != 0.0) {
            double d2 = Math.toRadians(d);
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            mxPoint mxPoint2 = new mxPoint(mxRectangle2.getX() + mxRectangle2.getWidth() / 2.0, mxRectangle2.getY() + mxRectangle2.getHeight() / 2.0);
            mxPoint mxPoint3 = new mxPoint(mxRectangle2.getX(), mxRectangle2.getY());
            mxPoint mxPoint4 = new mxPoint(mxRectangle2.getX() + mxRectangle2.getWidth(), mxRectangle2.getY());
            mxPoint mxPoint5 = new mxPoint(mxPoint4.getX(), mxRectangle2.getY() + mxRectangle2.getHeight());
            mxPoint mxPoint6 = new mxPoint(mxRectangle2.getX(), mxPoint5.getY());
            mxPoint3 = mxUtils.getRotatedPoint(mxPoint3, d3, d4, mxPoint2);
            mxPoint4 = mxUtils.getRotatedPoint(mxPoint4, d3, d4, mxPoint2);
            mxPoint5 = mxUtils.getRotatedPoint(mxPoint5, d3, d4, mxPoint2);
            mxPoint6 = mxUtils.getRotatedPoint(mxPoint6, d3, d4, mxPoint2);
            Rectangle rectangle = new Rectangle((int)mxPoint3.getX(), (int)mxPoint3.getY(), 0, 0);
            rectangle.add(mxPoint4.getPoint());
            rectangle.add(mxPoint5.getPoint());
            rectangle.add(mxPoint6.getPoint());
            mxRectangle3 = new mxRectangle(rectangle);
        }
        return mxRectangle3;
    }

    public static mxPoint getRotatedPoint(mxPoint mxPoint2, double d, double d2) {
        return mxUtils.getRotatedPoint(mxPoint2, d, d2, new mxPoint());
    }

    public static mxPoint getRotatedPoint(mxPoint mxPoint2, double d, double d2, mxPoint mxPoint3) {
        double d3 = mxPoint2.getX() - mxPoint3.getX();
        double d4 = mxPoint2.getY() - mxPoint3.getY();
        double d5 = d3 * d - d4 * d2;
        double d6 = d4 * d + d3 * d2;
        return new mxPoint(d5 + mxPoint3.getX(), d6 + mxPoint3.getY());
    }

    public static void drawImageClip(Graphics graphics, BufferedImage bufferedImage, ImageObserver imageObserver) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = Math.max(0, Math.min(rectangle.x, n));
            int n4 = Math.max(0, Math.min(rectangle.y, n2));
            n = Math.min(rectangle.width, n - n3);
            n2 = Math.min(rectangle.height, n2 - n4);
            if (n > 0 && n2 > 0) {
                graphics.drawImage(bufferedImage.getSubimage(n3, n4, n, n2), rectangle.x, rectangle.y, imageObserver);
            }
        } else {
            graphics.drawImage(bufferedImage, 0, 0, imageObserver);
        }
    }

    public static void fillClippedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        try {
            if (graphics.getClipBounds() != null) {
                rectangle = rectangle.intersection(graphics.getClipBounds());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static List translatePoints(List list, double d, double d2) {
        ArrayList<mxPoint> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<mxPoint>(list.size());
            for (Object e : list) {
                if (e instanceof mxPoint) {
                    mxPoint mxPoint2 = (mxPoint)((mxPoint)e).clone();
                    mxPoint2.setX(mxPoint2.getX() + d);
                    mxPoint2.setY(mxPoint2.getY() + d2);
                    arrayList.add(mxPoint2);
                    continue;
                }
                arrayList.add((mxPoint)e);
            }
        }
        return arrayList;
    }

    public static mxPoint intersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        double d10 = (d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5);
        double d11 = (d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5);
        double d12 = d10 / d9;
        double d13 = d11 / d9;
        if (d12 >= 0.0 && d12 <= 1.0 && d13 >= 0.0 && d13 <= 1.0) {
            double d14 = d + d12 * (d3 - d);
            double d15 = d2 + d12 * (d4 - d2);
            return new mxPoint(d14, d15);
        }
        return null;
    }

    public static String getStylename(String string) {
        String[] stringArray;
        String string2;
        if (string != null && (string2 = (stringArray = string.split(";"))[0]).indexOf("=") < 0) {
            return string2;
        }
        return "";
    }

    public static String[] getStylenames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf("=") >= 0) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return (String[])arrayList.toArray();
    }

    public static int indexOfStylename(String string, String string2) {
        if (string != null && string2 != null) {
            String[] stringArray = string.split(";");
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(string2)) {
                    return n;
                }
                n += stringArray[i].length() + 1;
            }
        }
        return -1;
    }

    public String addStylename(String string, String string2) {
        if (mxUtils.indexOfStylename(string, string2) < 0) {
            if (string == null) {
                string = "";
            } else if (string.length() > 0 && string.charAt(string.length() - 1) != ';') {
                string = string + ';';
            }
            string = string + string2;
        }
        return string;
    }

    public String removeStylename(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(string2)) continue;
                stringBuffer.append(stringArray[i] + ";");
            }
        }
        return stringBuffer.length() > 1 ? stringBuffer.substring(0, stringBuffer.length() - 1) : stringBuffer.toString();
    }

    public static String removeAllStylenames(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(61) < 0) continue;
                stringBuffer.append(stringArray[i] + ";");
            }
        }
        return stringBuffer.length() > 1 ? stringBuffer.substring(0, stringBuffer.length() - 1) : stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCellStyles(mxIGraphModel mxIGraphModel2, Object[] objectArray, String string, String string2) {
        if (objectArray != null && objectArray.length > 0) {
            mxIGraphModel2.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    String string3 = mxUtils.setStyle(mxIGraphModel2.getStyle(objectArray[i]), string, string2);
                    mxIGraphModel2.setStyle(objectArray[i], string3);
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    public static String setStyle(String string, String string2, String string3) {
        boolean bl;
        boolean bl2 = bl = string3 != null && string3.length() > 0;
        if (string == null || string.length() == 0) {
            if (bl) {
                string = string2 + "=" + string3;
            }
        } else {
            int n = string.indexOf(string2 + "=");
            if (n < 0) {
                if (bl) {
                    String string4 = string.endsWith(";") ? "" : ";";
                    string = string + string4 + string2 + '=' + string3;
                }
            } else {
                String string5 = bl ? string2 + "=" + string3 : "";
                int n2 = string.indexOf(";", n);
                string = string.substring(0, n) + string5 + (n2 >= 0 ? string.substring(n2) : "");
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCellStyleFlags(mxIGraphModel mxIGraphModel2, Object[] objectArray, String string, int n, Boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            mxIGraphModel2.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) continue;
                    String string2 = mxUtils.setStyleFlag(mxIGraphModel2.getStyle(objectArray[i]), string, n, bl);
                    mxIGraphModel2.setStyle(objectArray[i], string2);
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    public static String setStyleFlag(String string, String string2, int n, Boolean bl) {
        if (string == null || string.length() == 0) {
            string = bl == null || bl.booleanValue() ? string2 + "=" + n : string2 + "=0";
        } else {
            int n2 = string.indexOf(string2 + "=");
            if (n2 < 0) {
                String string3;
                String string4 = string3 = string.endsWith(";") ? "" : ";";
                string = bl == null || bl.booleanValue() ? string + string3 + string2 + "=" + n : string + string3 + string2 + "=0";
            } else {
                int n3 = string.indexOf(";", n2);
                String string5 = "";
                int n4 = 0;
                string5 = n3 < 0 ? string.substring(n2 + string2.length() + 1) : string.substring(n2 + string2.length() + 1, n3);
                n4 = bl == null ? Integer.parseInt(string5) ^ n : (bl != false ? Integer.parseInt(string5) | n : Integer.parseInt(string5) & ~n);
                string = string.substring(0, n2) + string2 + "=" + n4 + (n3 >= 0 ? string.substring(n3) : "");
            }
        }
        return string;
    }

    public static boolean isTrue(Hashtable hashtable, String string) {
        return mxUtils.isTrue(hashtable, string, false);
    }

    public static boolean isTrue(Hashtable hashtable, String string, boolean bl) {
        Object v = hashtable.get(string);
        if (v == null) {
            return bl;
        }
        if (v.equals("0")) {
            return false;
        }
        return v.equals("1") || Boolean.parseBoolean(v.toString());
    }

    public static int getInt(Hashtable hashtable, String string) {
        return mxUtils.getInt(hashtable, string, 0);
    }

    public static int getInt(Hashtable hashtable, String string, int n) {
        Object v = hashtable.get(string);
        if (v == null) {
            return n;
        }
        return (int)Float.parseFloat(v.toString());
    }

    public static float getFloat(Hashtable hashtable, String string) {
        return mxUtils.getFloat(hashtable, string, 0.0f);
    }

    public static float getFloat(Hashtable hashtable, String string, float f) {
        Object v = hashtable.get(string);
        if (v == null) {
            return f;
        }
        return Float.parseFloat(v.toString());
    }

    public static double getDouble(Hashtable hashtable, String string) {
        return mxUtils.getDouble(hashtable, string, 0.0);
    }

    public static double getDouble(Hashtable hashtable, String string, double d) {
        Object v = hashtable.get(string);
        if (v == null) {
            return d;
        }
        return Double.parseDouble(v.toString());
    }

    public static String getString(Hashtable hashtable, String string) {
        return mxUtils.getString(hashtable, string, null);
    }

    public static String getString(Hashtable hashtable, String string, String string2) {
        Object v = hashtable.get(string);
        if (v == null) {
            return string2;
        }
        return v.toString();
    }

    public static Color getColor(Hashtable hashtable, String string) {
        return mxUtils.getColor(hashtable, string, null);
    }

    public static Color getColor(Hashtable hashtable, String string, Color color) {
        Object v = hashtable.get(string);
        if (v == null) {
            return color;
        }
        return mxUtils.parseColor(v.toString());
    }

    public static Font getFont(Hashtable hashtable) {
        return mxUtils.getFont(hashtable, 1.0);
    }

    public static Font getFont(Hashtable hashtable, double d) {
        String string = mxUtils.getString(hashtable, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILY);
        int n = mxUtils.getInt(hashtable, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE);
        int n2 = mxUtils.getInt(hashtable, mxConstants.STYLE_FONTSTYLE);
        int n3 = (n2 & 1) == 1 ? 1 : 0;
        return new Font(string, n3 += (n2 & 2) == 2 ? 2 : 0, (int)Math.round((double)n * d));
    }

    public static String hexString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return String.format("#%02X%02X%02X", n, n2, n3);
    }

    public static Color parseColor(String string) throws NumberFormatException {
        int n;
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("turqoise")) {
            return new Color(0, 255, 255);
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("none")) {
            return null;
        }
        try {
            n = (int)Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            n = Long.decode(string).intValue();
        }
        return new Color(n);
    }

    public static String getHexColorString(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF | color.getAlpha() << 24);
    }

    public static String readFile(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            stringBuffer.append(string2 + "\n");
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void writeFile(String string, String string2) throws IOException {
        FileWriter fileWriter = new FileWriter(string2);
        fileWriter.write(string);
        fileWriter.flush();
        fileWriter.close();
    }

    public static String getMd5Hash(String string) {
        StringBuffer stringBuffer = new StringBuffer(32);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes());
            Formatter formatter = new Formatter(stringBuffer);
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < byArray.length; ++i) {
                formatter.format("%02x", new Byte(byArray[i]));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static boolean isNode(Object object, String string) {
        return mxUtils.isNode(object, string, null, null);
    }

    public static boolean isNode(Object object, String string, String string2, String string3) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string == null || element.getNodeName().equalsIgnoreCase(string)) {
                String string4 = string2 != null ? element.getAttribute(string2) : null;
                return string2 == null || string4 != null && string4.equals(string3);
            }
        }
        return false;
    }

    public static void setAntiAlias(Graphics2D graphics2D, boolean bl, boolean bl2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl2 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static void clearRect(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
    }

    public static BufferedImage createBufferedImage(int n, int n2, Color color) {
        BufferedImage bufferedImage = null;
        if (n > 0 && n2 > 0) {
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.maxMemory();
            long l2 = runtime.totalMemory();
            int n3 = 4;
            long l3 = n * n2 * n3 / 1024;
            long l4 = runtime.freeMemory();
            long l5 = (l4 + (l - l2)) / 1024L;
            if (l3 <= l5) {
                try {
                    int n4 = color != null ? 1 : 2;
                    bufferedImage = new BufferedImage(n, n2, n4);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    mxUtils.clearRect(graphics2D, new Rectangle(n, n2), color);
                    graphics2D.dispose();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
            }
        }
        return bufferedImage;
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public static Document createSvgDocument(int n, int n2) {
        Document document = mxUtils.createDocument();
        Element element = document.createElement("svg");
        String string = String.valueOf(n);
        String string2 = String.valueOf(n2);
        element.setAttribute("width", string);
        element.setAttribute("height", string2);
        element.setAttribute("viewBox", "0 0 " + string + " " + string2);
        element.setAttribute("version", "1.1");
        element.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        document.appendChild(element);
        return document;
    }

    public static Document createVmlDocument() {
        Document document = mxUtils.createDocument();
        Element element = document.createElement("html");
        element.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        element.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        document.appendChild(element);
        Element element2 = document.createElement("head");
        Element element3 = document.createElement("style");
        element3.setAttribute("type", "text/css");
        element3.appendChild(document.createTextNode("<!-- v\\:* {behavior: url(#default#VML);} -->"));
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element4 = document.createElement("body");
        element.appendChild(element4);
        return document;
    }

    public static Document createHtmlDocument() {
        Document document = mxUtils.createDocument();
        Element element = document.createElement("html");
        document.appendChild(element);
        Element element2 = document.createElement("head");
        element.appendChild(element2);
        Element element3 = document.createElement("body");
        element.appendChild(element3);
        return document;
    }

    public static HTMLDocument createHtmlDocument(Hashtable hashtable) {
        return mxUtils.createHtmlDocument(hashtable, 1.0);
    }

    public static HTMLDocument createHtmlDocument(Hashtable hashtable, double d) {
        String string;
        int n;
        HTMLDocument hTMLDocument = new HTMLDocument();
        StringBuffer stringBuffer = new StringBuffer("body {");
        stringBuffer.append(" font-family: " + mxUtils.getString(hashtable, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES) + " ; ");
        stringBuffer.append(" font-size: " + (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * d) + " pt ;");
        String string2 = mxUtils.getString(hashtable, mxConstants.STYLE_FONTCOLOR);
        if (string2 != null) {
            stringBuffer.append("color: " + string2 + " ; ");
        }
        if (((n = mxUtils.getInt(hashtable, mxConstants.STYLE_FONTSTYLE)) & 1) == 1) {
            stringBuffer.append(" font-weight: bold ; ");
        }
        if ((n & 2) == 2) {
            stringBuffer.append(" font-style: italic ; ");
        }
        if ((n & 4) == 4) {
            stringBuffer.append(" text-decoration: underline ; ");
        }
        if ((string = mxUtils.getString(hashtable, mxConstants.STYLE_ALIGN, "left")).equals("center")) {
            stringBuffer.append(" text-align: center ; ");
        } else if (string.equals("right")) {
            stringBuffer.append(" text-align: right ; ");
        }
        stringBuffer.append(" } ");
        hTMLDocument.getStyleSheet().addRule(stringBuffer.toString());
        return hTMLDocument;
    }

    public static Element createTable(Document document, String string, int n, int n2, int n3, int n4, double d, Hashtable hashtable) {
        Element element = document.createElement("table");
        if (string != null && string.length() > 0) {
            float f;
            String string2;
            Element element2 = document.createElement("tr");
            Element element3 = document.createElement("td");
            element.setAttribute("cellspacing", "0");
            element.setAttribute("border", "0");
            element3.setAttribute("align", "center");
            String string3 = mxUtils.getString(hashtable, mxConstants.STYLE_FONTCOLOR, "black");
            String string4 = mxUtils.getString(hashtable, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
            int n5 = (int)((double)mxUtils.getInt(hashtable, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * d);
            String string5 = "position:absolute;left:" + String.valueOf(n) + "px;" + "top:" + String.valueOf(n2) + "px;" + "width:" + String.valueOf(n3) + "px;" + "height:" + String.valueOf(n4) + "px;" + "font-size:" + String.valueOf(n5) + "px;" + "font-family:" + string4 + ";" + "color:" + string3 + ";";
            String string6 = mxUtils.getString(hashtable, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
            if (string6 != null) {
                string5 = string5 + "background:" + string6 + ";";
            }
            if ((string2 = mxUtils.getString(hashtable, mxConstants.STYLE_LABEL_BORDERCOLOR)) != null) {
                string5 = string5 + "border:" + string2 + " solid 1pt;";
            }
            if ((f = mxUtils.getFloat(hashtable, mxConstants.STYLE_TEXT_OPACITY, 100.0f)) < 100.0f) {
                string5 = string5 + "filter:alpha(opacity=" + f + ");";
                string5 = string5 + "opacity:" + f / 100.0f + ";";
            }
            element3.setAttribute("style", string5);
            String[] stringArray = string.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                element3.appendChild(document.createTextNode(stringArray[i]));
                element3.appendChild(document.createElement("br"));
            }
            element2.appendChild(element3);
            element.appendChild(element2);
        }
        return element;
    }

    public static Image loadImage(String string) {
        BufferedImage bufferedImage = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            uRL = mxUtils.class.getResource(string);
        }
        if (string != null) {
            try {
                bufferedImage = ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedImage;
    }

    public static Document loadDocument(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Document parse(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object eval(String string) {
        Class clazz;
        int n = string.lastIndexOf(".");
        if (n > 0 && (clazz = mxCodecRegistry.getClassForName(string.substring(0, n))) != null) {
            try {
                return clazz.getField(string.substring(n + 1)).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static Node selectSingleNode(Document document, String string) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            return (Node)xPath.evaluate(string, document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String htmlEntities(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&prime;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getXml(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(node);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(dOMSource, streamResult);
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getPrettyXml(Node node) {
        return mxUtils.getPrettyXml(node, "  ", "");
    }

    public static String getPrettyXml(Node node, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node != null) {
            if (node.getNodeType() == 3) {
                stringBuffer.append(node.getNodeValue());
            } else {
                Node node2;
                stringBuffer.append(string2 + "<" + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        String string3 = namedNodeMap.item(i).getNodeValue();
                        stringBuffer.append(" " + namedNodeMap.item(i).getNodeName() + "=\"" + string3 + "\"");
                    }
                }
                if ((node2 = node.getFirstChild()) != null) {
                    stringBuffer.append(">\n");
                    while (node2 != null) {
                        stringBuffer.append(mxUtils.getPrettyXml(node2, string, string2 + string));
                        node2 = node2.getNextSibling();
                    }
                    stringBuffer.append(string2 + "</" + node.getNodeName() + ">\n");
                } else {
                    stringBuffer.append("/>\n");
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        try {
            fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

