/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class mxRubberband
implements MouseListener,
MouseMotionListener {
    protected boolean enabled = true;
    protected Color borderColor = mxConstants.RUBBERBAND_BORDERCOLOR;
    protected Color fillColor = mxConstants.RUBBERBAND_FILLCOLOR;
    protected mxGraphComponent graphComponent;
    protected transient Point first;
    protected transient Rectangle bounds;

    public mxRubberband(final mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        mxGraphComponent2.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object object, Object[] objectArray) {
                mxRubberband.this.paintRubberband((Graphics)objectArray[0]);
            }
        });
        mxGraphComponent2.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && mxGraphComponent2.isEscapeEnabled()) {
                    mxRubberband.this.reset();
                }
            }
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public boolean isRubberbandTrigger(MouseEvent mouseEvent) {
        return true;
    }

    public void start(Point point) {
        this.first = point;
        this.bounds = new Rectangle(this.first);
    }

    public void reset() {
        this.first = null;
        if (this.bounds != null) {
            this.graphComponent.getGraphControl().repaint(this.bounds);
            this.bounds = null;
        }
    }

    public Object[] select(Rectangle rectangle, MouseEvent mouseEvent) {
        return this.graphComponent.selectRegion(rectangle, mouseEvent);
    }

    public void paintRubberband(Graphics graphics) {
        if (this.first != null && this.bounds != null && this.graphComponent.isSignificant(this.bounds.width, this.bounds.height)) {
            Rectangle rectangle = new Rectangle(this.bounds);
            graphics.setColor(this.fillColor);
            mxUtils.fillClippedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.borderColor);
            --rectangle.width;
            --rectangle.height;
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.isEnabled() && this.isRubberbandTrigger(mouseEvent) && !mouseEvent.isPopupTrigger()) {
            this.start(mouseEvent.getPoint());
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.first != null) {
            Rectangle rectangle = new Rectangle(this.bounds);
            this.bounds = new Rectangle(this.first);
            this.bounds.add(mouseEvent.getPoint());
            if (this.graphComponent.isSignificant(this.bounds.width, this.bounds.height)) {
                Rectangle rectangle2;
                int n;
                mxGraphComponent.mxGraphControl mxGraphControl2 = this.graphComponent.getGraphControl();
                Rectangle rectangle3 = new Rectangle(rectangle);
                rectangle3.add(this.bounds);
                if (this.bounds.x != rectangle.x) {
                    n = Math.max(this.bounds.x, rectangle.x);
                    rectangle2 = new Rectangle(rectangle3.x - 1, rectangle3.y, n - rectangle3.x + 2, rectangle3.height);
                    mxGraphControl2.repaint(rectangle2);
                }
                if (this.bounds.x + this.bounds.width != rectangle.x + rectangle.width) {
                    n = Math.min(this.bounds.x + this.bounds.width, rectangle.x + rectangle.width);
                    rectangle2 = new Rectangle(n - 1, rectangle3.y, rectangle3.x + rectangle3.width - n + 1, rectangle3.height);
                    mxGraphControl2.repaint(rectangle2);
                }
                if (this.bounds.y != rectangle.y) {
                    n = Math.max(this.bounds.y, rectangle.y);
                    rectangle2 = new Rectangle(rectangle3.x, rectangle3.y - 1, rectangle3.width, n - rectangle3.y + 2);
                    mxGraphControl2.repaint(rectangle2);
                }
                if (this.bounds.y + this.bounds.height != rectangle.y + rectangle.height) {
                    n = Math.min(this.bounds.y + this.bounds.height, rectangle.y + rectangle.height);
                    rectangle2 = new Rectangle(rectangle3.x, n - 1, rectangle3.width, rectangle3.y + rectangle3.height - n + 1);
                    mxGraphControl2.repaint(rectangle2);
                }
                if (!this.graphComponent.isToggleEvent(mouseEvent) && !this.graphComponent.getGraph().isSelectionEmpty()) {
                    this.graphComponent.getGraph().clearSelection();
                }
            }
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.bounds;
        this.reset();
        if (!mouseEvent.isConsumed() && rectangle != null && this.graphComponent.isSignificant(rectangle.width, rectangle.height)) {
            this.select(rectangle, mouseEvent);
            mouseEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

