/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraphView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class mxCellMarker
extends JComponent {
    public static String EVENT_MARK = "mark";
    public static Stroke DEFAULT_STROKE = new BasicStroke(3.0f);
    protected mxEventSource eventSource = new mxEventSource(this);
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected double hotspot;
    protected boolean hotspotEnabled = false;
    protected boolean swimlaneContentEnabled = false;
    protected Color validColor;
    protected Color invalidColor;
    protected transient Color currentColor;
    protected transient mxCellState validState;
    protected transient mxCellState markedState;

    public mxCellMarker(mxGraphComponent mxGraphComponent2) {
        this(mxGraphComponent2, mxConstants.DEFAULT_VALID_COLOR);
    }

    public mxCellMarker(mxGraphComponent mxGraphComponent2, Color color) {
        this(mxGraphComponent2, color, mxConstants.DEFAULT_INVALID_COLOR);
    }

    public mxCellMarker(mxGraphComponent mxGraphComponent2, Color color, Color color2) {
        this(mxGraphComponent2, color, color2, mxConstants.DEFAULT_HOTSPOT);
    }

    public mxCellMarker(mxGraphComponent mxGraphComponent2, Color color, Color color2, double d) {
        this.graphComponent = mxGraphComponent2;
        this.validColor = color;
        this.invalidColor = color2;
        this.hotspot = d;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setHotspot(double d) {
        this.hotspot = d;
    }

    public double getHotspot() {
        return this.hotspot;
    }

    public void setHotspotEnabled(boolean bl) {
        this.hotspotEnabled = bl;
    }

    public boolean isHotspotEnabled() {
        return this.hotspotEnabled;
    }

    public void setSwimlaneContentEnabled(boolean bl) {
        this.swimlaneContentEnabled = bl;
    }

    public boolean isSwimlaneContentEnabled() {
        return this.swimlaneContentEnabled;
    }

    public boolean hasValidState() {
        return this.validState != null;
    }

    public mxCellState getValidState() {
        return this.validState;
    }

    public mxCellState getMarkedState() {
        return this.markedState;
    }

    public void reset() {
        this.validState = null;
        if (this.markedState != null) {
            this.markedState = null;
            this.unmark();
        }
    }

    public mxCellState process(MouseEvent mouseEvent) {
        mxCellState mxCellState2 = null;
        if (this.isEnabled()) {
            mxCellState2 = this.getState(mouseEvent);
            boolean bl = mxCellState2 != null ? this.isValidState(mxCellState2) : false;
            Color color = this.getMarkerColor(mouseEvent, mxCellState2, bl);
            this.validState = bl ? mxCellState2 : null;
            if (mxCellState2 != this.markedState || color != this.currentColor) {
                this.currentColor = color;
                if (mxCellState2 != null && this.currentColor != null) {
                    this.markedState = mxCellState2;
                    this.mark();
                } else if (this.markedState != null) {
                    this.markedState = null;
                    this.unmark();
                }
            }
        }
        return mxCellState2;
    }

    protected void mark() {
        if (this.markedState != null) {
            Rectangle rectangle = this.markedState.getRectangle();
            rectangle.grow(3, 3);
            ++rectangle.width;
            ++rectangle.height;
            this.setBounds(rectangle);
            if (this.getParent() == null) {
                this.setVisible(true);
                this.graphComponent.getGraphControl().add(this);
            }
            this.repaint();
            this.eventSource.fireEvent(EVENT_MARK, new Object[]{this.markedState});
        }
    }

    protected void unmark() {
        if (this.getParent() != null) {
            this.setVisible(false);
            this.getParent().remove(this);
            this.eventSource.fireEvent(EVENT_MARK);
        }
    }

    protected boolean isValidState(mxCellState mxCellState2) {
        return true;
    }

    protected Color getMarkerColor(MouseEvent mouseEvent, mxCellState mxCellState2, boolean bl) {
        return bl ? this.validColor : this.invalidColor;
    }

    protected mxCellState getState(MouseEvent mouseEvent) {
        Object object;
        mxGraphView mxGraphView2 = this.graphComponent.getGraph().getView();
        mxCellState mxCellState2 = this.getStateToMark(mxGraphView2.getState(object = this.getCell(mouseEvent)));
        return mxCellState2 != null && this.intersects(mxCellState2, mouseEvent) ? mxCellState2 : null;
    }

    protected Object getCell(MouseEvent mouseEvent) {
        return this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), this.swimlaneContentEnabled);
    }

    protected mxCellState getStateToMark(mxCellState mxCellState2) {
        return mxCellState2;
    }

    protected boolean intersects(mxCellState mxCellState2, MouseEvent mouseEvent) {
        if (this.hotspotEnabled && this.hotspot > 0.0) {
            int n = (int)mxCellState2.getCenterX();
            int n2 = (int)mxCellState2.getCenterY();
            int n3 = (int)mxCellState2.getWidth();
            int n4 = (int)mxCellState2.getHeight();
            int n5 = mxUtils.getInt(mxCellState2.getStyle(), mxConstants.STYLE_STARTSIZE);
            if (n5 > 0) {
                if (mxUtils.isTrue(mxCellState2.getStyle(), mxConstants.STYLE_HORIZONTAL, true)) {
                    n2 = (int)(mxCellState2.getY() + (double)(n5 / 2));
                    n4 = n5;
                } else {
                    n = (int)(mxCellState2.getX() + (double)(n5 / 2));
                    n3 = n5;
                }
            }
            int n6 = (int)Math.max((double)mxConstants.MIN_HOTSPOT_SIZE, (double)n3 * this.hotspot);
            int n7 = (int)Math.max((double)mxConstants.MIN_HOTSPOT_SIZE, (double)n4 * this.hotspot);
            if (mxConstants.MAX_HOTSPOT_SIZE > 0) {
                n6 = Math.min(n6, mxConstants.MAX_HOTSPOT_SIZE);
                n7 = Math.min(n7, mxConstants.MAX_HOTSPOT_SIZE);
            }
            Rectangle rectangle = new Rectangle(n - n6 / 2, n2 - n7 / 2, n6, n7);
            return rectangle.contains(mouseEvent.getPoint());
        }
        return true;
    }

    public void addListener(String string, mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.addListener(string, mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.removeListener(mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2, String string) {
        this.eventSource.removeListener(mxIEventListener2, string);
    }

    public void paint(Graphics graphics) {
        if (this.markedState != null && this.currentColor != null) {
            ((Graphics2D)graphics).setStroke(DEFAULT_STROKE);
            graphics.setColor(this.currentColor);
            if (this.markedState.getAbsolutePointCount() > 0) {
                Point point = this.markedState.getAbsolutePoint(0).getPoint();
                for (int i = 1; i < this.markedState.getAbsolutePointCount(); ++i) {
                    Point point2 = this.markedState.getAbsolutePoint(i).getPoint();
                    graphics.drawLine(point.x - this.getX(), point.y - this.getY(), point2.x - this.getX(), point2.y - this.getY());
                    point = point2;
                }
            } else {
                graphics.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            }
        }
    }
}

