/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxVmlCanvas
extends mxBasicCanvas {
    protected Document document;

    public mxVmlCanvas() {
        this(null);
    }

    public mxVmlCanvas(Document document) {
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void appendVmlElement(Element element) {
        Node node;
        if (this.document != null && (node = this.document.getDocumentElement().getFirstChild().getNextSibling()) != null) {
            node.appendChild(element);
        }
    }

    public Object drawVertex(int n, int n2, int n3, int n4, Hashtable hashtable) {
        Element element = null;
        int n5 = mxUtils.getInt(hashtable, mxConstants.STYLE_STARTSIZE);
        n += this.translate.x;
        n2 += this.translate.y;
        if (n5 == 0) {
            element = this.drawShape(n, n2, n3, n4, hashtable);
        } else {
            n5 = (int)Math.round((double)n5 * this.scale);
            Hashtable hashtable2 = new Hashtable(hashtable);
            hashtable2.remove(mxConstants.STYLE_FILLCOLOR);
            hashtable2.remove(mxConstants.STYLE_ROUNDED);
            if (mxUtils.isTrue(hashtable, mxConstants.STYLE_HORIZONTAL, true)) {
                element = this.drawShape(n, n2, n3, n5, hashtable);
                this.drawShape(n, n2 + n5, n3, n4 - n5, hashtable2);
            } else {
                element = this.drawShape(n, n2, n5, n4, hashtable);
                this.drawShape(n + n5, n2, n3 - n5, n4, hashtable2);
            }
        }
        return element;
    }

    public Object drawEdge(List list, Hashtable hashtable) {
        list = mxUtils.translatePoints(list, this.translate.x, this.translate.y);
        Element element = this.drawLine(list, hashtable);
        String string = mxUtils.getString(hashtable, mxConstants.STYLE_STARTARROW);
        String string2 = mxUtils.getString(hashtable, mxConstants.STYLE_ENDARROW);
        if (string != null || string2 != null) {
            double d;
            String string3;
            String string4;
            Element element2 = this.document.createElement("v:stroke");
            if (string != null) {
                element2.setAttribute("startarrow", string);
                string4 = "medium";
                string3 = "medium";
                d = (double)mxUtils.getFloat(hashtable, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE) * this.scale;
                if (d < 6.0) {
                    string4 = "narrow";
                    string3 = "short";
                } else if (d > 10.0) {
                    string4 = "wide";
                    string3 = "long";
                }
                element2.setAttribute("startarrowwidth", string4);
                element2.setAttribute("startarrowlength", string3);
            }
            if (string2 != null) {
                element2.setAttribute("endarrow", string2);
                string4 = "medium";
                string3 = "medium";
                d = (double)mxUtils.getFloat(hashtable, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE) * this.scale;
                if (d < 6.0) {
                    string4 = "narrow";
                    string3 = "short";
                } else if (d > 10.0) {
                    string4 = "wide";
                    string3 = "long";
                }
                element2.setAttribute("endarrowwidth", string4);
                element2.setAttribute("endarrowlength", string3);
            }
            element.appendChild(element2);
        }
        return element;
    }

    public Object drawLabel(String string, int n, int n2, int n3, int n4, Hashtable hashtable, boolean bl) {
        if (this.drawLabels) {
            return this.drawText(string, n += this.translate.x, n2 += this.translate.y, n3, n4, hashtable);
        }
        return null;
    }

    public Element drawShape(int n, int n2, int n3, int n4, Hashtable hashtable) {
        Element element;
        String string;
        String string2 = mxUtils.getString(hashtable, mxConstants.STYLE_FILLCOLOR);
        String string3 = mxUtils.getString(hashtable, mxConstants.STYLE_GRADIENTCOLOR);
        String string4 = mxUtils.getString(hashtable, mxConstants.STYLE_STROKECOLOR);
        float f = (float)((double)mxUtils.getFloat(hashtable, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        String string5 = mxUtils.getString(hashtable, mxConstants.STYLE_SHAPE);
        Element element2 = null;
        if (string5.equals("image")) {
            String string6 = this.getImageForStyle(hashtable);
            if (string6 != null) {
                element2 = this.document.createElement("v:img");
                element2.setAttribute("src", string6);
            }
        } else if (string5.equals("line")) {
            String string7 = mxUtils.getString(hashtable, mxConstants.STYLE_DIRECTION, "east");
            string = null;
            if (string7.equals("east") || string7.equals("west")) {
                int n5 = Math.round(n4 / 2);
                string = "m 0 " + n5 + " l " + n3 + " " + n5;
            } else {
                int n6 = Math.round(n3 / 2);
                string = "m " + n6 + " 0 L " + n6 + " " + n4;
            }
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            element2.setAttribute("path", string + " x e");
        } else if (string5.equals("ellipse")) {
            element2 = this.document.createElement("v:oval");
        } else if (string5.equals("doubleEllipse")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            int n7 = (int)((double)(3.0f + f) * this.scale);
            string = "ar 0 0 " + n3 + " " + n4 + " 0 " + n4 / 2 + " " + n3 / 2 + " " + n4 / 2 + " e ar " + n7 + " " + n7 + " " + (n3 - n7) + " " + (n4 - n7) + " 0 " + n4 / 2 + " " + n3 / 2 + " " + n4 / 2;
            element2.setAttribute("path", string + " x e");
        } else if (string5.equals("rhombus")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string8 = "m " + n3 / 2 + " 0 l " + n3 + " " + n4 / 2 + " l " + n3 / 2 + " " + n4 + " l 0 " + n4 / 2;
            element2.setAttribute("path", string8 + " x e");
        } else if (string5.equals("triangle")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string9 = mxUtils.getString(hashtable, mxConstants.STYLE_DIRECTION, "");
            string = null;
            string = string9.equals("north") ? "m 0 " + n4 + " l " + n3 / 2 + " 0 " + " l " + n3 + " " + n4 : (string9.equals("south") ? "m 0 0 l " + n3 / 2 + " " + n4 + " l " + n3 + " 0" : (string9.equals("west") ? "m " + n3 + " 0 l " + n3 + " " + n4 / 2 + " l " + n3 + " " + n4 : "m 0 0 l " + n3 + " " + n4 / 2 + " l 0 " + n4));
            element2.setAttribute("path", string + " x e");
        } else if (string5.equals("hexagon")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string10 = mxUtils.getString(hashtable, mxConstants.STYLE_DIRECTION, "");
            string = null;
            string = string10.equals("north") || string10.equals("south") ? "m " + (int)(0.5 * (double)n3) + " 0 l " + n3 + " " + (int)(0.25 * (double)n4) + " l " + n3 + " " + (int)(0.75 * (double)n4) + " l " + (int)(0.5 * (double)n3) + " " + n4 + " l 0 " + (int)(0.75 * (double)n4) + " l 0 " + (int)(0.25 * (double)n4) : "m " + (int)(0.25 * (double)n3) + " 0 l " + (int)(0.75 * (double)n3) + " 0 l " + n3 + " " + (int)(0.5 * (double)n4) + " l " + (int)(0.75 * (double)n3) + " " + n4 + " l " + (int)(0.25 * (double)n3) + " " + n4 + " l 0 " + (int)(0.5 * (double)n4);
            element2.setAttribute("path", string + " x e");
        } else if (string5.equals("cloud")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string11 = "m " + (int)(0.25 * (double)n3) + " " + (int)(0.25 * (double)n4) + " c " + (int)(0.05 * (double)n3) + " " + (int)(0.25 * (double)n4) + " 0 " + (int)(0.5 * (double)n4) + " " + (int)(0.16 * (double)n3) + " " + (int)(0.55 * (double)n4) + " c 0 " + (int)(0.66 * (double)n4) + " " + (int)(0.18 * (double)n3) + " " + (int)(0.9 * (double)n4) + " " + (int)(0.31 * (double)n3) + " " + (int)(0.8 * (double)n4) + " c " + (int)(0.4 * (double)n3) + " " + n4 + " " + (int)(0.7 * (double)n3) + " " + n4 + " " + (int)(0.8 * (double)n3) + " " + (int)(0.8 * (double)n4) + " c " + n3 + " " + (int)(0.8 * (double)n4) + " " + n3 + " " + (int)(0.6 * (double)n4) + " " + (int)(0.875 * (double)n3) + " " + (int)(0.5 * (double)n4) + " c " + n3 + " " + (int)(0.3 * (double)n4) + " " + (int)(0.8 * (double)n3) + " " + (int)(0.1 * (double)n4) + " " + (int)(0.625 * (double)n3) + " " + (int)(0.2 * (double)n4) + " c " + (int)(0.5 * (double)n3) + " " + (int)(0.05 * (double)n4) + " " + (int)(0.3 * (double)n3) + " " + (int)(0.05 * (double)n4) + " " + (int)(0.25 * (double)n3) + " " + (int)(0.25 * (double)n4);
            element2.setAttribute("path", string11 + " x e");
        } else if (string5.equals("actor")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            double d = n3 / 3;
            String string12 = "m 0 " + n4 + " C 0 " + 3 * n4 / 5 + " 0 " + 2 * n4 / 5 + " " + n3 / 2 + " " + 2 * n4 / 5 + " c " + (int)((double)(n3 / 2) - d) + " " + 2 * n4 / 5 + " " + (int)((double)(n3 / 2) - d) + " 0 " + n3 / 2 + " 0 c " + (int)((double)(n3 / 2) + d) + " 0 " + (int)((double)(n3 / 2) + d) + " " + 2 * n4 / 5 + " " + n3 / 2 + " " + 2 * n4 / 5 + " c " + n3 + " " + 2 * n4 / 5 + " " + n3 + " " + 3 * n4 / 5 + " " + n3 + " " + n4;
            element2.setAttribute("path", string12 + " x e");
        } else if (string5.equals("cylinder")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            double d = Math.min(40.0, Math.floor(n4 / 5));
            String string13 = "m 0 " + (int)d + " C 0 " + (int)(d / 3.0) + " " + n3 + " " + (int)(d / 3.0) + " " + n3 + " " + (int)d + " L " + n3 + " " + (int)((double)n4 - d) + " C " + n3 + " " + (int)((double)n4 + d / 3.0) + " 0 " + (int)((double)n4 + d / 3.0) + " 0 " + (int)((double)n4 - d) + " x e" + " m 0 " + (int)d + " C 0 " + (int)(2.0 * d) + " " + n3 + " " + (int)(2.0 * d) + " " + n3 + " " + (int)d;
            element2.setAttribute("path", string13 + " e");
        } else {
            element2 = this.document.createElement("v:rect");
        }
        String string14 = "position:absolute;left:" + String.valueOf(n) + "px;top:" + String.valueOf(n2) + "px;width:" + String.valueOf(n3) + "px;height:" + String.valueOf(n4) + "px;";
        double d = mxUtils.getDouble(hashtable, mxConstants.STYLE_ROTATION);
        if (d != 0.0) {
            string14 = string14 + "rotation:" + d + ";";
        }
        element2.setAttribute("style", string14);
        if (mxUtils.isTrue(hashtable, mxConstants.STYLE_SHADOW, false) && string2 != null) {
            Element element3 = this.document.createElement("v:shadow");
            element3.setAttribute("on", "true");
            element2.appendChild(element3);
        }
        float f2 = mxUtils.getFloat(hashtable, mxConstants.STYLE_OPACITY, 100.0f);
        if (string2 != null) {
            element = this.document.createElement("v:fill");
            element.setAttribute("color", string2);
            if (f2 != 100.0f) {
                element.setAttribute("opacity", String.valueOf(f2 / 100.0f));
            }
            element2.appendChild(element);
        } else {
            element2.setAttribute("filled", "false");
        }
        if (string4 != null) {
            element2.setAttribute("strokecolor", string4);
            element = this.document.createElement("v:stroke");
            if (f2 != 100.0f) {
                element.setAttribute("opacity", String.valueOf(f2 / 100.0f));
            }
            element2.appendChild(element);
        } else {
            element2.setAttribute("stroked", "false");
        }
        element2.setAttribute("strokeweight", String.valueOf(f) + "pt");
        this.appendVmlElement(element2);
        return element2;
    }

    public Element drawLine(List list, Hashtable hashtable) {
        String string = mxUtils.getString(hashtable, mxConstants.STYLE_STROKECOLOR);
        float f = (float)((double)mxUtils.getFloat(hashtable, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        Element element = this.document.createElement("v:shape");
        if (string != null && f > 0.0f) {
            mxPoint mxPoint2 = (mxPoint)list.get(0);
            Rectangle rectangle = new Rectangle(mxPoint2.getPoint());
            String string2 = "m " + Math.round(mxPoint2.getX()) + " " + Math.round(mxPoint2.getY());
            for (int i = 1; i < list.size(); ++i) {
                mxPoint2 = (mxPoint)list.get(i);
                string2 = string2 + " l " + Math.round(mxPoint2.getX()) + " " + Math.round(mxPoint2.getY());
                rectangle = rectangle.union(new Rectangle(mxPoint2.getPoint()));
            }
            element.setAttribute("path", string2);
            element.setAttribute("filled", "false");
            element.setAttribute("strokecolor", string);
            element.setAttribute("strokeweight", String.valueOf(f) + "pt");
            String string3 = "position:absolute;left:" + String.valueOf(rectangle.x) + "px;" + "top:" + String.valueOf(rectangle.y) + "px;" + "width:" + String.valueOf(rectangle.width) + "px;" + "height:" + String.valueOf(rectangle.height) + "px;";
            element.setAttribute("style", string3);
            element.setAttribute("coordorigin", String.valueOf(rectangle.x) + " " + String.valueOf(rectangle.y));
            element.setAttribute("coordsize", String.valueOf(rectangle.width) + " " + String.valueOf(rectangle.height));
        }
        this.appendVmlElement(element);
        return element;
    }

    public Element drawText(String string, int n, int n2, int n3, int n4, Hashtable hashtable) {
        Element element = mxUtils.createTable(this.document, string, n, n2, n3, n4, this.scale, hashtable);
        this.appendVmlElement(element);
        return element;
    }
}

