/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.agent;

import com.sun.btrace.agent.Main;
import com.sun.btrace.runtime.ProbeDescriptor;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;

final class ProbeDescriptorLoader {
    private static String[] probeDescDirs;
    private static Map<String, ProbeDescriptor> probeDescMap;

    private ProbeDescriptorLoader() {
    }

    static void init(String probeDescPath) {
        probeDescDirs = probeDescPath.split(File.pathSeparator);
    }

    static synchronized ProbeDescriptor load(String namespace) {
        ProbeDescriptor res = probeDescMap.get(namespace);
        if (res != null) {
            if (Main.isDebug()) {
                Main.debugPrint("probe descriptor cache hit for " + namespace);
            }
            return res;
        }
        File file = ProbeDescriptorLoader.findFile(namespace);
        if (file == null) {
            return null;
        }
        ProbeDescriptor pd = ProbeDescriptorLoader.load(file);
        if (pd != null) {
            if (Main.isDebug()) {
                Main.debugPrint("read probe descriptor for " + namespace);
            }
            probeDescMap.put(namespace, pd);
        }
        return pd;
    }

    private static ProbeDescriptor load(File file) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.sun.btrace.annotations:com.sun.btrace.runtime");
            if (Main.isDebug()) {
                Main.debugPrint("reading " + file);
            }
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            return (ProbeDescriptor)u.unmarshal(file);
        }
        catch (JAXBException exp) {
            if (Main.isDebug()) {
                Main.debugPrint(exp);
            }
            return null;
        }
    }

    private static File findFile(String namespace) {
        for (String dir : probeDescDirs) {
            File f = new File(dir, namespace + ".xml");
            if (!f.exists() || !f.isFile()) continue;
            if (Main.isDebug()) {
                Main.debugPrint("probe descriptor for " + namespace + " is " + f);
            }
            return f;
        }
        if (Main.isDebug()) {
            Main.debugPrint("no probe descriptor found for " + namespace);
        }
        return null;
    }

    static {
        probeDescMap = Collections.synchronizedMap(new HashMap());
    }
}

