package cerot.blight.btrace;

import java.util.Date;

/**
 * メソッド表現のモデルクラス。
 * @author cero-t
 * 
 */
public abstract class MethodExpression {
	/** 呼び出し時間 */
	private Date date;

	/** 呼び出し先クラス名 */
	private String className;

	/** メソッド名 */
	private String methodName;

	/**
	 * 呼び出し時間を取得します。
	 * @return 呼び出し時間
	 */
	public Date getDate() {
		return this.date;
	}

	/**
	 * 呼び出し時間を設定します。
	 * @param date 呼び出し時間
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * 呼び出し先クラス名を取得します。
	 * @return 呼び出し先クラス名
	 */
	public String getClassName() {
		return this.className;
	}

	/**
	 * 呼び出し先クラス名を設定します。
	 * @param className 呼び出し先クラス名
	 */
	public void setClassName(String className) {
		this.className = className;
	}

	/**
	 * メソッド名を取得します。
	 * @return メソッド名
	 */
	public String getMethodName() {
		return this.methodName;
	}

	/**
	 * メソッド名を設定します。
	 * @param methodName メソッド名
	 */
	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}
}
