package cerot.blight.btrace;

import java.util.Arrays;

/**
 * メソッド呼び出しのモデルクラス。
 * @author cero-t
 *
 */
public class MethodCall extends MethodExpression {
	/** 引数のクラス */
	private String[] argTypes;

	/** 引数の値 */
	private String[] args;

	/**
	 * 引数のクラスを取得します。
	 * @return 引数のクラス
	 */
	public String[] getArgTypes() {
		return this.argTypes;
	}

	/**
	 * 引数のクラスを設定します。
	 * @param argTypes 引数のクラス
	 */
	public void setArgTypes(String[] argTypes) {
		this.argTypes = argTypes;
	}

	/**
	 * 引数の値を取得します。
	 * @return 引数の値
	 */
	public String[] getArgs() {
		return this.args;
	}

	/**
	 * 引数の値を設定します。
	 * @param args 引数の値
	 */
	public void setArgs(String[] args) {
		this.args = args;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("date=" + this.getDate());
		builder.append(",className=" + this.getClassName());
		builder.append(",methodName=" + this.getMethodName());
		builder.append(",argTypes=" + Arrays.toString(this.getArgs()));
		builder.append(",args=" + Arrays.toString(this.getArgs()));
		return new String(builder);
	}
}
