package org.phosphoresce.commons.mail;

import java.util.LinkedList;
import java.util.List;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Flags.Flag;

import org.phosphoresce.commons.mail.exception.MailException;
import org.phosphoresce.commons.mail.exception.MailTransactionException;

/**
 * [MgUNVNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 *-->
 */
public final class MailReciveTransaction extends MailTransaction {

	/**
	 * RXgN^<br>
	 * @param configuration ݒIuWFNg
	 */
	public MailReciveTransaction(MailConfiguration configuration) {
		super(configuration);
	}

	/**
	 * [T[o[̃bZ[W擾܂B<br>
	 * @return [T[o[̃bZ[W
	 * @throws MailException ɎMsȂꍇɔ܂
	 * @throws MailTransactionException gUNVJnĂȂԂŏsꂽꍇɔ܂
	 */
	public int getMessageCount() throws MailException, MailTransactionException {
		try {
			// gUNVÓw`FbN
			if (!isOpened()) {
				throw new MailTransactionException("gUNVJnĂ܂");
			}

			return getFolder().getMessageCount();
		} catch (MessagingException e) {
			throw new MailException("ɃbZ[W̎擾s܂ł", e);
		}
	}

	/**
	 * [T[o[̖ǃbZ[W擾܂B<br>
	 * @return [T[o[̖ǃbZ[W
	 * @throws MailException ɎMsȂꍇɔ܂
	 * @throws MailTransactionException gUNVJnĂȂԂŏsꂽꍇɔ܂
	 */
	public int getUnreadMessageCount() throws MailException, MailTransactionException {
		try {
			// gUNVÓw`FbN
			if (!isOpened()) {
				throw new MailTransactionException("gUNVJnĂ܂");
			}

			return getFolder().getUnreadMessageCount();
		} catch (MessagingException e) {
			throw new MailException("ɖǃbZ[W̎擾s܂ł", e);
		}
	}

	/**
	 * [T[o[̐VbZ[W擾܂B<br>
	 * @return [T[o[̐VbZ[W
	 * @throws MailException ɎMsȂꍇɔ܂
	 * @throws MailTransactionException gUNVJnĂȂԂŏsꂽꍇɔ܂
	 */
	public int getNewMessageCount() throws MailException, MailTransactionException {
		try {
			// gUNVÓw`FbN
			if (!isOpened()) {
				throw new MailTransactionException("gUNVJnĂ܂");
			}

			return getFolder().getNewMessageCount();
		} catch (MessagingException e) {
			throw new MailException("ɖǃbZ[W̎擾s܂ł", e);
		}
	}

	/**
	 * [M܂B<br>
	 * @return [bZ[WIuWFNg
	 * @throws MailException ɎMsȂꍇɔ܂
	 * @throws MailTransactionException gUNVJnĂȂԂŏsꂽꍇɔ܂
	 */
	public MailMessage[] recive() throws MailException, MailTransactionException {
		try {
			// gUNVÓw`FbN
			if (!isOpened()) {
				throw new MailTransactionException("gUNVJnĂ܂");
			}

			// bZ[W擾
			List list = new LinkedList();
			if (getMessageCount() > 0) {
				Message[] messages = getFolder().getMessages();
				for (int i = 0; i <= messages.length - 1; i++) {
					Message message = messages[i];
					getFolder().setFlags(new Message[] { message }, new Flags(Flag.DELETED), true);
					list.add(new MailMessage(message));
				}
			}

			return (MailMessage[]) list.toArray(new MailMessage[list.size()]);
		} catch (Exception e) {
			throw new MailException("ɃbZ[WM邱Ƃo܂ł", e);
		}
	}
}
