/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.mail.Part;
import javax.mail.internet.MimeUtility;
import org.phosphoresce.commons.mail.exception.MailIOException;
import org.phosphoresce.commons.mail.exception.MailResourceException;
import org.phosphoresce.commons.mail.mail.MailUtil;
import org.phosphoresce.commons.util.StringUtil;

public final class MailAttachResource
implements Serializable {
    private boolean income = false;
    private String name = "";
    private Part part = null;
    private File file = null;

    MailAttachResource(Part part) throws MailResourceException {
        try {
            this.income = true;
            this.name = StringUtil.isEmpty((String)part.getFileName()) ? MailUtil.getContentType(part, "name") : MimeUtility.decodeText((String)part.getFileName());
            this.part = part;
        }
        catch (Exception e) {
            throw new MailResourceException("\u53d7\u4fe1\u7528\u30ea\u30bd\u30fc\u30b9\u3068\u3057\u3066\u30af\u30e9\u30b9\u3092\u521d\u671f\u5316\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    MailAttachResource(File file) throws MailResourceException {
        try {
            this.income = false;
            this.name = file.getName();
            this.file = file;
        }
        catch (Exception e) {
            throw new MailResourceException("\u9001\u4fe1\u7528\u30ea\u30bd\u30fc\u30b9\u3068\u3057\u3066\u30af\u30e9\u30b9\u3092\u521d\u671f\u5316\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public boolean isIncome() {
        return this.income;
    }

    public String getName() {
        return this.name;
    }

    private InputStream getInputStream() throws MailIOException {
        try {
            if (this.income) {
                return this.part.getInputStream();
            }
            return new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new MailIOException("\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u30ea\u30bd\u30fc\u30b9\u306eInputStream\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    Part getPart() throws MailResourceException {
        if (!this.isIncome()) {
            throw new MailResourceException("\u53d7\u4fe1\u7528\u30ea\u30bd\u30fc\u30b9\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u306a\u3044\u70ba\u3001Part\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u53d6\u5f97\u306f\u884c\u3048\u307e\u305b\u3093");
        }
        return this.part;
    }

    File getFile() throws MailResourceException {
        if (this.isIncome()) {
            throw new MailResourceException("\u9001\u4fe1\u7528\u30ea\u30bd\u30fc\u30b9\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u306a\u3044\u70ba\u3001File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u53d6\u5f97\u306f\u884c\u3048\u307e\u305b\u3093");
        }
        return this.file;
    }

    public void save(File file) throws MailIOException {
        try {
            int i;
            int READ_BYTE = 8192;
            File target = file.isDirectory() ? new File((file.getAbsolutePath().endsWith(File.separator) ? file.getAbsolutePath() : file.getAbsolutePath() + File.separator) + StringUtil.escapeFilename((String)this.name, (String)"_")) : file;
            FileOutputStream os = new FileOutputStream(target);
            InputStream is = this.getInputStream();
            byte[] bytes = new byte[8192];
            while ((i = is.read(bytes)) > 0) {
                os.write(bytes, 0, i);
            }
            os.close();
        }
        catch (Exception e) {
            throw new MailIOException("\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u30ea\u30bd\u30fc\u30b9\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    public void save(String path) throws MailIOException {
        this.save(new File(path));
    }
}

