/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import org.phosphoresce.commons.csv.CSVRecord;
import org.phosphoresce.commons.csv.CSVRecordList;
import org.phosphoresce.commons.csv.CSVToken;

public final class CSVManager
implements Serializable {
    private String value = null;
    private boolean inQuote = false;

    private CSVManager(String value) {
        this.value = value;
    }

    public static CSVRecordList createRecordList(String value) {
        return new CSVManager(value).execute();
    }

    public static CSVRecordList createRecordList(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        CSVRecordList list = CSVManager.createRecordList(is);
        is.close();
        return list;
    }

    public static CSVRecordList createRecordList(InputStream is) throws IOException {
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while (reader.ready()) {
            buffer.append(reader.readLine());
            buffer.append("\n");
        }
        return CSVManager.createRecordList(buffer.toString());
    }

    public static void save(CSVRecordList list, String path) throws IOException {
        CSVManager.save(list, new File(path));
    }

    public static void save(CSVRecordList list, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        CSVManager.save(list, os);
        os.close();
    }

    public static void save(CSVRecordList list, OutputStream os) {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(os));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CSVRecord tokens = (CSVRecord)iterator.next();
            writer.println(tokens.getRecordValue());
            writer.flush();
        }
        writer.flush();
    }

    private CSVRecordList execute() {
        CSVRecordList recordList = new CSVRecordList();
        CSVRecord tokenList = new CSVRecord();
        StringBuffer token = new StringBuffer();
        for (int i = 0; i <= this.value.length() - 1; ++i) {
            String s2;
            String s1 = String.valueOf(this.value.charAt(i));
            String string = s2 = i < this.value.length() - 1 ? String.valueOf(this.value.charAt(i + 1)) : "";
            if (!this.inQuote) {
                if (",".equals(s1)) {
                    tokenList.add(new CSVToken(CSVToken.decode(token.toString())));
                    token = new StringBuffer();
                    continue;
                }
                if ("\n".equals(s1)) {
                    tokenList.add(new CSVToken(CSVToken.decode(token.toString())));
                    recordList.add(tokenList);
                    token = new StringBuffer();
                    tokenList = new CSVRecord();
                    continue;
                }
                if ("\"".equals(s1)) {
                    token.append(s1);
                    this.inQuote = true;
                    continue;
                }
                token.append(s1);
                continue;
            }
            if (",".equals(s1)) {
                token.append(s1);
                continue;
            }
            if ("\n".equals(s1)) {
                token.append(s1);
                continue;
            }
            if ("\"".equals(s1) && "\"".equals(s2)) {
                token.append(s1);
                token.append(s2);
                ++i;
                continue;
            }
            if ("\"".equals(s1) && !"\"".equals(s2)) {
                token.append(s1);
                this.inQuote = false;
                continue;
            }
            token.append(s1);
        }
        return recordList;
    }
}

