package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EFrame;
import org.phosphoresce.commons.eswing.EMenu;
import org.phosphoresce.commons.eswing.EMenuBar;
import org.phosphoresce.commons.eswing.EMenuItem;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.ETabbedPane;
import org.phosphoresce.dbbrowser.DatabaseBrowserConstants;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.FrameStatusBarPanel;
import org.phosphoresce.dbbrowser.gui.common.window.ConnectionConfigureFrame;
import org.phosphoresce.dbbrowser.gui.common.window.MessageDialog;
import org.phosphoresce.dbbrowser.gui.panel.dbinformation.DatabaseInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.pcinformation.ClientPCInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManagePanel;
import org.phosphoresce.dbbrowser.gui.window.about.AboutDialog;

/**
 * DatabaseBrowserCt[NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/16	Kitagawa		VK쐬
 *-->
 */
public class DatabaseBrowserFrame extends EFrame implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** CReipl */
	private EPanel mainContainerPanel = null;

	/** t[Xe[^Xo[pl */
	private FrameStatusBarPanel frameStatusBarPanel = null;

	/** ^uyC */
	private ETabbedPane browserTabbedPane = null;

	/** NCAgpl */
	private ClientPCInformationPanel clientPCInformationPanel = null;

	/** f[^x[Xpl */
	private DatabaseInformationPanel databaseInformationPanel = null;

	/** NG}l[Wpl */
	private QueryManagePanel queryManagerPanel = null;

	/** uEUj[o[ */
	private EMenuBar browserMenuBar = null;

	/** uEUj[(File) */
	private EMenu browserMenuFile = null;

	/** uEUj[(View) */
	private EMenu browserMenuView = null;

	/** uEUj[(Help) */
	private EMenu browserMenuHelp = null;

	/** uEUj[ACe(About) */
	private EMenuItem browserMenuItemAbout = null;

	/** uEUj[ACe(NewConnection) */
	private EMenuItem browserMenuItemNewConnection = null;

	/** uEUj[ACe(ClientInformationView) */
	private EMenuItem browserMenuItemClientInformationView = null;

	/** uEUj[ACe(DatabaseInformationView) */
	private EMenuItem browserMenuItemDatabaseInformationView = null;

	/** uEUj[ACe(QueryManagerView) */
	private EMenuItem browserMenuItemQueryManagerView = null;

	/**
	 * RXgN^<br>
	 */
	public DatabaseBrowserFrame() {
		super();
		initialize();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setSize(new Dimension(900, 700));
		this.setContentPane(getMainContainerPanel());
		this.setIconImage(DatabaseBrowserImages.IMAGE_APP_ICON_32);
		this.setJMenuBar(getBrowserMenuBar());
		this.setTitle(DatabaseBrowserConstants.APPLICATION_TITLE);
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		for (int i = 0; i <= getBrowserTabbedPane().getTabCount() - 1; i++) {
			Component component = getBrowserTabbedPane().getComponentAt(i);
			if (component instanceof RefreshableComponent) {
				((RefreshableComponent) component).refresh();
			}
		}
		getFrameStatusBarPanel().refresh();
	}

	/**
	 * CReipl擾܂B<br>
	 * @return CReipl
	 */
	private EPanel getMainContainerPanel() {
		if (mainContainerPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 1;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 0.0;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.weighty = 1.0;
			mainContainerPanel = new EPanel();
			mainContainerPanel.setLayout(new GridBagLayout());
			mainContainerPanel.add(getBrowserTabbedPane(), gridBagConstraints);
			mainContainerPanel.add(getFrameStatusBarPanel(), gridBagConstraints1);
		}
		return mainContainerPanel;
	}

	/**
	 * t[Xe[^Xo[pl擾܂B<br>
	 * @return t[Xe[^Xo[pl
	 */
	private FrameStatusBarPanel getFrameStatusBarPanel() {
		if (frameStatusBarPanel == null) {
			frameStatusBarPanel = FrameStatusBarPanel.instance();
		}
		return frameStatusBarPanel;
	}

	/**
	 * ^uyC^uyC擾܂B<br>
	 * @return ^uyC^uyC
	 */
	private ETabbedPane getBrowserTabbedPane() {
		if (browserTabbedPane == null) {
			browserTabbedPane = new ETabbedPane();
			browserTabbedPane.addTab("Client Information", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_20), getClientPCInformationPanel(), "Client PC Information");
			browserTabbedPane.addTab("Database Information", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_20), getDatabaseInformationPanel(), "Database Information");
			browserTabbedPane.addTab("Query Manager", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_20), getQueryManagerPanel(), "Query Manager");
			browserTabbedPane.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					if (browserTabbedPane.getSelectedComponent() instanceof RefreshableComponent) {
						try {
							((RefreshableComponent) browserTabbedPane.getSelectedComponent()).refresh();
						} catch (Throwable throwable) {
							String errorMessage = "failed to refresh browser panel.";
							log.error(errorMessage, throwable);
							MessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
						}
					}
				}
			});
			// \plXV
			try {
				getClientPCInformationPanel().refresh();
			} catch (Throwable throwable) {
				String errorMessage = "failed to refresh client pc information panel.";
				log.error(errorMessage, throwable);
				MessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
			}
		}
		return browserTabbedPane;
	}

	/**
	 * NCAgpl擾܂B<br>
	 * @return NCAgpl
	 */
	private ClientPCInformationPanel getClientPCInformationPanel() {
		if (clientPCInformationPanel == null) {
			clientPCInformationPanel = new ClientPCInformationPanel();
		}
		return clientPCInformationPanel;
	}

	/**
	 * f[^x[Xpl擾܂B<br>
	 * @return f[^x[Xpl
	 */
	private DatabaseInformationPanel getDatabaseInformationPanel() {
		if (databaseInformationPanel == null) {
			databaseInformationPanel = new DatabaseInformationPanel();
		}
		return databaseInformationPanel;
	}

	/**
	 * NG}l[Wpl擾܂B<br>
	 * @return NG}l[Wpl
	 */
	private QueryManagePanel getQueryManagerPanel() {
		if (queryManagerPanel == null) {
			queryManagerPanel = new QueryManagePanel();
		}
		return queryManagerPanel;
	}

	/**
	 * uEUj[o[擾܂B<br>
	 * @return uEUj[o[
	 */
	private EMenuBar getBrowserMenuBar() {
		if (browserMenuBar == null) {
			browserMenuBar = new EMenuBar();
			browserMenuBar.add(getBrowserMenuFile());
			browserMenuBar.add(getBrowserMenuView());
			browserMenuBar.add(getBrowserMenuHelp());
		}
		return browserMenuBar;
	}

	/**
	 * uEUj[(File)擾܂B<br>
	 * @return uEUj[(File)
	 */
	private EMenu getBrowserMenuFile() {
		if (browserMenuFile == null) {
			browserMenuFile = new EMenu("File");
			browserMenuFile.setMnemonic('F');
			browserMenuFile.add(getBrowserMenuItemNewConnection());
		}
		return browserMenuFile;
	}

	/**
	 * uEUj[(Window)擾܂B<br>
	 * @return uEUj[(Window)
	 */
	private EMenu getBrowserMenuView() {
		if (browserMenuView == null) {
			browserMenuView = new EMenu("View");
			browserMenuView.setMnemonic('V');
			browserMenuView.add(getBrowserMenuItemClientInformationView());
			browserMenuView.add(getBrowserMenuItemDatabaseInformationView());
			browserMenuView.add(getBrowserMenuItemQueryManagerView());
		}
		return browserMenuView;
	}

	/**
	 * uEUj[(Help)擾܂B<br>
	 * @return uEUj[(Help)
	 */
	private EMenu getBrowserMenuHelp() {
		if (browserMenuHelp == null) {
			browserMenuHelp = new EMenu("Help");
			browserMenuHelp.setMnemonic('H');
			browserMenuHelp.add(getBrowserMenuItemAbout());
		}
		return browserMenuHelp;
	}

	/**
	 * uEUj[ACe(About)擾܂B<br>
	 * @return uEUj[ACe(About)
	 */
	private EMenuItem getBrowserMenuItemAbout() {
		if (browserMenuItemAbout == null) {
			browserMenuItemAbout = new EMenuItem("About...");
			browserMenuItemAbout.setMnemonic('A');
			browserMenuItemAbout.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						new AboutDialog(DatabaseBrowserSession.instance().getBrowserFrame(), true).setVisible(true);
					} catch (Throwable throwable) {
						String errorMessage = "failed to show about dialog.";
						log.error(errorMessage, throwable);
						MessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
					}
				}
			});
		}
		return browserMenuItemAbout;
	}

	/**
	 * uEUj[ACe(NewConnection)擾܂B<br>
	 * @return uEUj[ACe(NewConnection)
	 */
	private EMenuItem getBrowserMenuItemNewConnection() {
		if (browserMenuItemNewConnection == null) {
			browserMenuItemNewConnection = new EMenuItem("New Connection...");
			browserMenuItemNewConnection.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						new ConnectionConfigureFrame(DatabaseBrowserSession.instance().getBrowserFrame(), DatabaseBrowserSession.instance()).setVisible(true);
						refresh();
					} catch (Throwable throwable) {
						String errorMessage = "failed to connect new database instance.";
						log.error(errorMessage, throwable);
						MessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
					}
				}
			});
		}
		return browserMenuItemNewConnection;
	}

	/**
	 * uEUj[ACe(ClientInformationView)擾܂B<br>
	 * @return uEUj[ACe(ClientInformationView)
	 */
	private EMenuItem getBrowserMenuItemClientInformationView() {
		if (browserMenuItemClientInformationView == null) {
			browserMenuItemClientInformationView = new EMenuItem("ClientInformationView");
			browserMenuItemClientInformationView.setMnemonic('C');
			browserMenuItemClientInformationView.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getBrowserTabbedPane().setSelectedIndex(0);
				}
			});
		}
		return browserMenuItemClientInformationView;
	}

	/**
	 * uEUj[ACe(DatabaseInformationView)擾܂B<br>
	 * @return uEUj[ACe(DatabaseInformationView)
	 */
	private EMenuItem getBrowserMenuItemDatabaseInformationView() {
		if (browserMenuItemDatabaseInformationView == null) {
			browserMenuItemDatabaseInformationView = new EMenuItem("DatabaseInformationView");
			browserMenuItemDatabaseInformationView.setMnemonic('D');
			browserMenuItemDatabaseInformationView.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getBrowserTabbedPane().setSelectedIndex(1);
				}
			});
		}
		return browserMenuItemDatabaseInformationView;
	}

	/**
	 * uEUj[ACe(QueryManagerView)擾܂B<br>
	 * @return uEUj[ACe(QueryManagerView)
	 */
	private EMenuItem getBrowserMenuItemQueryManagerView() {
		if (browserMenuItemQueryManagerView == null) {
			browserMenuItemQueryManagerView = new EMenuItem("QueryManagerView");
			browserMenuItemQueryManagerView.setMnemonic('Q');
			browserMenuItemQueryManagerView.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getBrowserTabbedPane().setSelectedIndex(2);
				}
			});
		}
		return browserMenuItemQueryManagerView;
	}
}
