package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.FrameHeaderPanel;

/**
 * NG[}l[Wpl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class QueryManagePanel extends EPanel implements RefreshableComponent, QueryManage {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** f[^x[XZbVnbVR[h */
	private int databaseSessionHashCode = 0;

	/** wb_pl */
	private FrameHeaderPanel frameHeaderPanel = null;

	/** RecyC */
	private EPanel contentsPane = null;

	/** NGGfB^Reipl */
	private QueryManageContainerPanel queryContainerPanel = null;

	/**
	 * RXgN^<br>
	 */
	public QueryManagePanel() {
		super();
		initialize();
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		if (DatabaseBrowserSession.instance().getDatabaseSession(DBSESSION_KEY).hashCode() != databaseSessionHashCode) {
			databaseSessionHashCode = DatabaseBrowserSession.instance().getDatabaseSession(DBSESSION_KEY).hashCode();
			getQueryContainerPanel().refresh();
		}
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 1.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0;
		gridBagConstraints2.weighty = 1.0;
		gridBagConstraints2.gridy = 1;
		gridBagConstraints2.gridx = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(800, 800));
		this.add(getFrameHeaderPanel(), gridBagConstraints1);
		this.add(getContentsPane(), gridBagConstraints2);
	}

	/**
	 * wb_pl擾܂B<br>
	 * @return wb_pl
	 */
	private FrameHeaderPanel getFrameHeaderPanel() {
		if (frameHeaderPanel == null) {
			frameHeaderPanel = new FrameHeaderPanel();
			frameHeaderPanel.setText("Query Manager");
			frameHeaderPanel.setHedaerIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_48));
			frameHeaderPanel.setDescription("Execute Select And Update Query.");
		}
		return frameHeaderPanel;
	}

	/**
	 * RecyC擾܂B<br>
	 * @return RecyC
	 */
	private EPanel getContentsPane() {
		if (contentsPane == null) {
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.weightx = 1.0D;
			gridBagConstraints3.weighty = 1.0D;
			gridBagConstraints3.gridx = 0;
			gridBagConstraints3.gridy = 3;
			contentsPane = new EPanel();
			contentsPane.setLayout(new GridBagLayout());
			contentsPane.add(getQueryContainerPanel(), gridBagConstraints3);
		}
		return contentsPane;
	}

	/**
	 * NGGfB^Reipl擾܂B<br>
	 * @return NGGfB^Reipl
	 */
	private QueryManageContainerPanel getQueryContainerPanel() {
		if (queryContainerPanel == null) {
			queryContainerPanel = new QueryManageContainerPanel();
		}
		return queryContainerPanel;
	}
}
