package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.SwingConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * NGGfB^{^pl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/20	Kitagawa		VK쐬
 *-->
 */
final class QueryManageButtonPanel extends EPanel implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** NGsIuWFNg */
	private QueryManageActionContainer actionContainer = null;

	/** Execute{^ */
	private EButton executeButton = null;

	/** Insertrow{^ */
	private EButton insertrowButton = null;

	/** Commit{^ */
	private EButton commitButton = null;

	/** Rollback{^ */
	private EButton rollbackButton = null;

	/** Deleterow{^ */
	private EButton deleterowButton = null;

	/** Save{^ */
	private EButton saveButton = null;

	/**
	 * RXgN^<br>
	 * @param executer NGsIuWFNg
	 */
	public QueryManageButtonPanel(QueryManageActionContainer executer) {
		super();
		this.actionContainer = executer;
		initialize();
	}

	/**
	 * RXgN^<br>
	 */
	private QueryManageButtonPanel() {
		this(null);
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.insets = new Insets(0, 3, 0, 3);
		gridBagConstraints5.weightx = 0.0;
		gridBagConstraints5.weighty = 0.0;
		gridBagConstraints5.gridy = 0;
		gridBagConstraints5.gridx = 5;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(0, 3, 0, 3);
		gridBagConstraints4.weightx = 0.0;
		gridBagConstraints4.weighty = 0.0;
		gridBagConstraints4.gridy = 0;
		gridBagConstraints4.gridx = 4;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(0, 3, 0, 3);
		gridBagConstraints3.weightx = 0.0;
		gridBagConstraints3.weighty = 0.0;
		gridBagConstraints3.gridy = 0;
		gridBagConstraints3.gridx = 3;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(0, 3, 0, 3);
		gridBagConstraints2.weightx = 0.0;
		gridBagConstraints2.weighty = 0.0;
		gridBagConstraints2.gridy = 0;
		gridBagConstraints2.gridx = 2;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(0, 3, 0, 3);
		gridBagConstraints1.weightx = 0.0;
		gridBagConstraints1.weighty = 0.0;
		gridBagConstraints1.gridy = 0;
		gridBagConstraints1.gridx = 1;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.insets = new Insets(0, 3, 0, 3);
		gridBagConstraints.weightx = 0.0;
		gridBagConstraints.weighty = 0.0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridx = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(600, 42));
		this.setPreferredSize(new Dimension(600, 42));
		this.setMaximumSize(new Dimension(600, 42));
		this.setMinimumSize(new Dimension(600, 42));
		this.add(getExecuteButton(), gridBagConstraints);
		this.add(getInsertrowButton(), gridBagConstraints1);
		this.add(getDeleterowButton(), gridBagConstraints2);
		this.add(getCommitButton(), gridBagConstraints3);
		this.add(getRollbackButton(), gridBagConstraints4);
		this.add(getSaveButton(), gridBagConstraints5);
	}

	/**
	 * Execute{^擾܂B<br>
	 * @return Execute{^
	 */
	private EButton getExecuteButton() {
		if (executeButton == null) {
			executeButton = new EButton();
			executeButton.setText("Execute");
			executeButton.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_BUTTON_ICON_EXECUTE_24));
			executeButton.setPreferredSize(new Dimension(96, 32));
			executeButton.setMaximumSize(new Dimension(96, 32));
			executeButton.setMinimumSize(new Dimension(96, 32));
			executeButton.setMargin(new Insets(0, 5, 0, 0));
			executeButton.setHorizontalAlignment(SwingConstants.LEFT);
			executeButton.setVerticalAlignment(SwingConstants.CENTER);
			executeButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					actionContainer.execute();
				}
			});
		}
		return executeButton;
	}

	/**
	 * Insertrow{^擾܂B<br>
	 * @return Insertrow{^
	 */
	private EButton getInsertrowButton() {
		if (insertrowButton == null) {
			insertrowButton = new EButton();
			insertrowButton.setText("Insertrow");
			insertrowButton.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_BUTTON_ICON_INSERTROW_24));
			insertrowButton.setPreferredSize(new Dimension(96, 32));
			insertrowButton.setMaximumSize(new Dimension(96, 32));
			insertrowButton.setMinimumSize(new Dimension(96, 32));
			insertrowButton.setMargin(new Insets(0, 5, 0, 0));
			insertrowButton.setHorizontalAlignment(SwingConstants.LEFT);
			insertrowButton.setVerticalAlignment(SwingConstants.CENTER);
			insertrowButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					actionContainer.inertrow();
				}
			});
		}
		return insertrowButton;
	}

	/**
	 * Commit{^擾܂B<br>
	 * @return Commit{^
	 */
	private EButton getCommitButton() {
		if (commitButton == null) {
			commitButton = new EButton();
			commitButton.setText("Commit");
			commitButton.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_BUTTON_ICON_COMMIT_24));
			commitButton.setPreferredSize(new Dimension(96, 32));
			commitButton.setMaximumSize(new Dimension(96, 32));
			commitButton.setMinimumSize(new Dimension(96, 32));
			commitButton.setMargin(new Insets(0, 5, 0, 0));
			commitButton.setHorizontalAlignment(SwingConstants.LEFT);
			commitButton.setVerticalAlignment(SwingConstants.CENTER);
			commitButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					actionContainer.commit();
				}
			});
		}
		return commitButton;
	}

	/**
	 * Rollback{^擾܂B<br>
	 * @return Rollback{^
	 */
	private EButton getRollbackButton() {
		if (rollbackButton == null) {
			rollbackButton = new EButton();
			rollbackButton.setText("Rollback");
			rollbackButton.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_BUTTON_ICON_ROLLBACK_24));
			rollbackButton.setPreferredSize(new Dimension(96, 32));
			rollbackButton.setMaximumSize(new Dimension(96, 32));
			rollbackButton.setMinimumSize(new Dimension(96, 32));
			rollbackButton.setMargin(new Insets(0, 5, 0, 0));
			rollbackButton.setHorizontalAlignment(SwingConstants.LEFT);
			rollbackButton.setVerticalAlignment(SwingConstants.CENTER);
			rollbackButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					actionContainer.rollback();
				}
			});
		}
		return rollbackButton;
	}

	/**
	 * Deleterow{^擾܂B<br>
	 * @return Deleterow{^
	 */
	private EButton getDeleterowButton() {
		if (deleterowButton == null) {
			deleterowButton = new EButton();
			deleterowButton.setText("Deleterow");
			deleterowButton.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_BUTTON_ICON_DELETEROW_24));
			deleterowButton.setPreferredSize(new Dimension(96, 32));
			deleterowButton.setMaximumSize(new Dimension(96, 32));
			deleterowButton.setMinimumSize(new Dimension(96, 32));
			deleterowButton.setMargin(new Insets(0, 5, 0, 0));
			deleterowButton.setHorizontalAlignment(SwingConstants.LEFT);
			deleterowButton.setVerticalAlignment(SwingConstants.CENTER);
			deleterowButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					actionContainer.deleterow();
				}
			});
		}
		return deleterowButton;
	}

	/**
	 * Save{^擾܂B<br>
	 * @return Save{^
	 */
	private EButton getSaveButton() {
		if (saveButton == null) {
			saveButton = new EButton();
			saveButton.setText("Save");
			saveButton.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_BUTTON_ICON_SAVE_24));
			saveButton.setPreferredSize(new Dimension(96, 32));
			saveButton.setMaximumSize(new Dimension(96, 32));
			saveButton.setMinimumSize(new Dimension(96, 32));
			saveButton.setMargin(new Insets(0, 5, 0, 0));
			saveButton.setHorizontalAlignment(SwingConstants.LEFT);
			saveButton.setVerticalAlignment(SwingConstants.CENTER);
			saveButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					actionContainer.save();
				}
			});
		}
		return saveButton;
	}
}
