package org.phosphoresce.dbbrowser.gui.panel.pcinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.ImageIcon;
import javax.swing.JScrollPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.FrameHeaderPanel;

/**
 * NCAgPCpl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class ClientPCInformationPanel extends EPanel implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** wb_pl */
	private FrameHeaderPanel frameHeaderPanel = null;

	/** RecXN[yC */
	private EScrollPane contentsScrollPane = null;

	/** RecyC */
	private EPanel contentsPane = null;

	/** RecplXy[T[ */
	private ELabel contentsPanelSpacer = null;

	/** VXetB[hZbg */
	private SystemInformationFieldSet systemInformationFieldSet = null;

	/** JavatB[hZbg */
	private JavaInformationFieldSet javaInformationFieldSet = null;

	/**
	 * RXgN^<br>
	 */
	public ClientPCInformationPanel() {
		super();
		initialize();
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		getSystemInformationFieldSet().refresh();
		getJavaInformationFieldSet().refresh();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 1.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0;
		gridBagConstraints2.weighty = 1.0;
		gridBagConstraints2.gridy = 1;
		gridBagConstraints2.gridx = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(800, 800));
		this.add(getFrameHeaderPanel(), gridBagConstraints1);
		this.add(getContentsScrollPane(), gridBagConstraints2);
	}

	/**
	 * wb_pl擾܂B<br>
	 * @return wb_pl
	 */
	private FrameHeaderPanel getFrameHeaderPanel() {
		if (frameHeaderPanel == null) {
			frameHeaderPanel = new FrameHeaderPanel();
			frameHeaderPanel.setText("Client PC Information");
			frameHeaderPanel.setHedaerIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_48));
			frameHeaderPanel.setDescription("Client Computer Informations.");
		}
		return frameHeaderPanel;
	}

	/**
	 * RecXN[yC擾܂B<br>
	 * @return RecXN[yC
	 */
	private EScrollPane getContentsScrollPane() {
		if (contentsScrollPane == null) {
			contentsScrollPane = new EScrollPane();
			contentsScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			contentsScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			contentsScrollPane.setBorder(null);
			contentsScrollPane.setViewportView(getContentsPane());
		}
		return contentsScrollPane;
	}

	/**
	 * RecyC擾܂B<br>
	 * @return RecyC
	 */
	private EPanel getContentsPane() {
		if (contentsPane == null) {
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.weightx = 1.0D;
			gridBagConstraints3.weighty = 1.0D;
			gridBagConstraints3.gridx = 0;
			gridBagConstraints3.gridy = 3;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.weightx = 1.0D;
			gridBagConstraints2.weighty = 0.0D;
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.gridy = 2;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.weightx = 1.0D;
			gridBagConstraints.weighty = 0.0D;
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = 1;
			contentsPane = new EPanel();
			contentsPane.setLayout(new GridBagLayout());
			contentsPane.add(getSystemInformationFieldSet(), gridBagConstraints);
			contentsPane.add(getJavaInformationFieldSet(), gridBagConstraints2);
			contentsPane.add(getContentsPanelSpacer(), gridBagConstraints3);
		}
		return contentsPane;
	}

	/**
	 * RecplXy[T[擾܂B<br>
	 * @return RecplXy[T[
	 */
	private ELabel getContentsPanelSpacer() {
		if (contentsPanelSpacer == null) {
			contentsPanelSpacer = new ELabel();
		}
		return contentsPanelSpacer;
	}

	/**
	 * VXetB[hZbg擾܂B<br>
	 * @return VXetB[hZbg
	 */
	private SystemInformationFieldSet getSystemInformationFieldSet() {
		if (systemInformationFieldSet == null) {
			systemInformationFieldSet = new SystemInformationFieldSet();
		}
		return systemInformationFieldSet;
	}

	/**
	 * JavatB[hZbg擾܂B<br>
	 * @return JavatB[hZbg
	 */
	private JavaInformationFieldSet getJavaInformationFieldSet() {
		if (javaInformationFieldSet == null) {
			javaInformationFieldSet = new JavaInformationFieldSet();
		}
		return javaInformationFieldSet;
	}
}
