package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.FrameHeaderPanel;
import org.phosphoresce.dbbrowser.gui.common.window.MessageDialog;

/**
 * f[^x[Xpl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class DatabaseInformationPanel extends EPanel implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** wb_pl */
	private FrameHeaderPanel frameHeaderPanel = null;

	/** RecXN[yC */
	private EScrollPane contentsScrollPane = null;

	/** RecyC */
	private EPanel contentsPane = null;

	/** RecplXy[T[ */
	private ELabel contentsPanelSpacer = null;

	/** {^pl */
	private EPanel buttonPanel = null;

	/** {^plXy[T[ */
	private ELabel buttonPanelSpacer = null;

	/** Refresh{^ */
	private EButton refreshButton = null;

	/** f[^x[X{tB[hZbg */
	private DatabaseInformationFieldSet databaseInformationFieldSet = null;

	/** JDBCڑtB[hZbg */
	private JdbcConnectionInformationFieldSet jdbcConnectionInformationFieldSet = null;

	/** f[^x[Xڍ׏tB[hZbg */
	private DatabaseDetailFieldSet databaseDetailsFeildSet = null;

	/** f[^xXNGdltB[hZbg */
	private DatabaseQuerySpecificationFieldSet databaseQuerySpecificationFieldSet = null;

	/** f[^x[XdltB[hZbg */
	private DatabaseSpecificationFieldSet databaseSpecificationFieldSet = null;

	/**
	 * RXgN^<br>
	 */
	public DatabaseInformationPanel() {
		super();
		initialize();
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		getDatabaseInformationFieldSet().refresh();
		getJdbcConnectionInformationFieldSet().refresh();
		getDatabaseDetailsFeildSet().refresh();
		getDatabaseSpecificationFieldSet().refresh();
		getDatabaseQuerySpecificationFieldSet().refresh();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 1.0;
		gridBagConstraints3.weighty = 0.0;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 2;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0;
		gridBagConstraints2.weighty = 1.0;
		gridBagConstraints2.gridy = 1;
		gridBagConstraints2.gridx = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 1.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(800, 800));
		this.add(getFrameHeaderPanel(), gridBagConstraints1);
		this.add(getContentsScrollPane(), gridBagConstraints2);
		this.add(getButtonPanel(), gridBagConstraints3);
	}

	/**
	 * wb_pl擾܂B<br>
	 * @return wb_pl
	 */
	private FrameHeaderPanel getFrameHeaderPanel() {
		if (frameHeaderPanel == null) {
			frameHeaderPanel = new FrameHeaderPanel();
			frameHeaderPanel.setText("Database Information");
			frameHeaderPanel.setHedaerIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_48));
			frameHeaderPanel.setDescription("Connecting Database Server Informations.");
		}
		return frameHeaderPanel;
	}

	/**
	 * RecXN[yC擾܂B<br>
	 * @return RecXN[yC
	 */
	private EScrollPane getContentsScrollPane() {
		if (contentsScrollPane == null) {
			contentsScrollPane = new EScrollPane();
			contentsScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			contentsScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			contentsScrollPane.setBorder(null);
			contentsScrollPane.setViewportView(getContentsPane());
		}
		return contentsScrollPane;
	}

	/**
	 * RecyC擾܂B<br>
	 * @return RecyC
	 */
	private EPanel getContentsPane() {
		if (contentsPane == null) {
			GridBagConstraints gridBagConstraints0 = new GridBagConstraints();
			gridBagConstraints0.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints0.fill = GridBagConstraints.BOTH;
			gridBagConstraints0.weightx = 1.0D;
			gridBagConstraints0.weighty = 0.0D;
			gridBagConstraints0.gridx = 0;
			gridBagConstraints0.gridy = 5;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.weightx = 1.0D;
			gridBagConstraints1.weighty = 0.0D;
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 4;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.weightx = 1.0D;
			gridBagConstraints2.weighty = 0.0D;
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.gridy = 3;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.weightx = 1.0D;
			gridBagConstraints3.weighty = 0.0D;
			gridBagConstraints3.gridx = 0;
			gridBagConstraints3.gridy = 2;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints4.fill = GridBagConstraints.BOTH;
			gridBagConstraints4.weightx = 1.0D;
			gridBagConstraints4.weighty = 0.0D;
			gridBagConstraints4.gridx = 0;
			gridBagConstraints4.gridy = 1;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.weightx = 1.0D;
			gridBagConstraints5.weighty = 0.0D;
			gridBagConstraints5.gridy = 0;
			gridBagConstraints5.gridx = 0;
			contentsPane = new EPanel();
			contentsPane.setLayout(new GridBagLayout());
			contentsPane.add(getDatabaseInformationFieldSet(), gridBagConstraints5);
			contentsPane.add(getJdbcConnectionInformationFieldSet(), gridBagConstraints4);
			contentsPane.add(getDatabaseDetailsFeildSet(), gridBagConstraints3);
			contentsPane.add(getDatabaseQuerySpecificationFieldSet(), gridBagConstraints2);
			contentsPane.add(getDatabaseSpecificationFieldSet(), gridBagConstraints1);
			contentsPane.add(getContentsPanelSpacer(), gridBagConstraints0);
		}
		return contentsPane;
	}

	/**
	 * RecplXy[T[擾܂B<br>
	 * @return RecplXy[T[
	 */
	private ELabel getContentsPanelSpacer() {
		if (contentsPanelSpacer == null) {
			contentsPanelSpacer = new ELabel();
		}
		return contentsPanelSpacer;
	}

	/**
	 * {^pl擾܂B<br>
	 * @return {^pl
	 */
	private EPanel getButtonPanel() {
		if (buttonPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.weightx = 0.0D;
			gridBagConstraints1.weighty = 1.0D;
			gridBagConstraints1.gridx = 1;
			gridBagConstraints1.gridy = 0;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.weightx = 1.0D;
			gridBagConstraints2.weighty = 1.0D;
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.gridy = 0;
			buttonPanel = new EPanel();
			buttonPanel.setLayout(new GridBagLayout());
			buttonPanel.setPreferredSize(new Dimension(500, 42));
			buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black));
			buttonPanel.add(getButtonPanelSpacer(), gridBagConstraints2);
			buttonPanel.add(getRefreshButton(), gridBagConstraints1);
		}
		return buttonPanel;
	}

	/**
	 * {^plXy[T[擾܂B<br>
	 * @return {^plXy[T[
	 */
	private ELabel getButtonPanelSpacer() {
		if (buttonPanelSpacer == null) {
			buttonPanelSpacer = new ELabel();
		}
		return buttonPanelSpacer;
	}

	/**
	 * Refresh{^擾܂B<br>
	 * @return Refresh{^
	 */
	private EButton getRefreshButton() {
		if (refreshButton == null) {
			refreshButton = new EButton();
			refreshButton.setText("Refresh");
			refreshButton.setPreferredSize(new Dimension(86, 24));
			refreshButton.setMinimumSize(new Dimension(86, 24));
			refreshButton.setMaximumSize(new Dimension(86, 24));
			refreshButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						refresh();
					} catch (Throwable ex) {
						MessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), "failed to refresh database information.", ex);
					}
				}
			});
		}
		return refreshButton;
	}

	/**
	 * f[^x[X{tB[hZbg擾܂B<br>
	 * @return f[^x[X{tB[hZbg
	 */
	private DatabaseInformationFieldSet getDatabaseInformationFieldSet() {
		if (databaseInformationFieldSet == null) {
			databaseInformationFieldSet = new DatabaseInformationFieldSet();
		}
		return databaseInformationFieldSet;
	}

	/**
	 * JDBCڑtB[hZbg擾܂B<br>
	 * @return JDBCڑtB[hZbg
	 */
	private JdbcConnectionInformationFieldSet getJdbcConnectionInformationFieldSet() {
		if (jdbcConnectionInformationFieldSet == null) {
			jdbcConnectionInformationFieldSet = new JdbcConnectionInformationFieldSet();
		}
		return jdbcConnectionInformationFieldSet;
	}

	/**
	 * f[^x[Xڍ׏tB[hZbg擾܂B<br>
	 * @return f[^x[Xڍ׏tB[hZbg
	 */
	private DatabaseDetailFieldSet getDatabaseDetailsFeildSet() {
		if (databaseDetailsFeildSet == null) {
			databaseDetailsFeildSet = new DatabaseDetailFieldSet();
		}
		return databaseDetailsFeildSet;
	}

	/**
	 * f[^xXNGdltB[hZbg擾܂B<br>
	 * @return f[^xXNGdltB[hZbg
	 */
	private DatabaseQuerySpecificationFieldSet getDatabaseQuerySpecificationFieldSet() {
		if (databaseQuerySpecificationFieldSet == null) {
			databaseQuerySpecificationFieldSet = new DatabaseQuerySpecificationFieldSet();
		}
		return databaseQuerySpecificationFieldSet;
	}

	/**
	 * f[^x[XdltB[hZbg擾܂B<br>
	 * @return f[^x[XdltB[hZbg
	 */
	private DatabaseSpecificationFieldSet getDatabaseSpecificationFieldSet() {
		if (databaseSpecificationFieldSet == null) {
			databaseSpecificationFieldSet = new DatabaseSpecificationFieldSet();
		}
		return databaseSpecificationFieldSet;
	}
}
