package org.phosphoresce.dbbrowser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.core.ESwingConfigManager;
import org.phosphoresce.dbbrowser.gui.window.main.DatabaseBrowserFrame;

/**
 * DatabaseBrowserAvP[VCNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/16	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowser {

	/** K[IuWFNg */
	private static Log log = LogFactory.getLog(DatabaseBrowser.class);

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowser() {
		super();
	}

	/**
	 * C\bh<br>
	 * @param args R}hC
	 */
	public static void main(String[] args) {
		try {
			ESwingConfigManager.configure();
			startup();
		} catch (Throwable throwable) {
			String errorMessage = "raised critical application exception.";
			log.error(errorMessage, throwable);
			System.exit(-1);
		}
	}

	/**
	 * DatabaseBrowserN܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 */
	private static void startup() throws Throwable {
		DatabaseBrowserSession browserSession = DatabaseBrowserSession.instance();
		DatabaseBrowserFrame browserFrame = new DatabaseBrowserFrame();

		browserSession.setBrowserFrame(browserFrame);

		browserFrame.setLocationRelativeTo(null);
		browserSession.initializeConfig();

		browserFrame.setVisible(true);
	}
}
