/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.QueryOperateException;

public final class DatabaseQueryManager {
    private Log log = LogFactory.getLog(this.getClass());
    private DatabaseSession session = null;
    private String query = null;
    private boolean executed = false;
    private int updateCount = 0;
    private ResultSet resultSet = null;
    private DatabaseError error = null;

    private DatabaseQueryManager() {
    }

    public DatabaseQueryManager(DatabaseSession session, String query) throws QueryOperateException {
        if (session == null) {
            throw new QueryOperateException("null 'session' argument.");
        }
        this.session = session;
        this.query = query;
        this.executed = false;
        this.updateCount = 0;
        this.resultSet = null;
        this.error = null;
    }

    public DatabaseQueryManager(DatabaseSession session) throws QueryOperateException {
        this(session, "");
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public ResultSet getResultSet() throws QueryOperateException {
        if (this.hasError()) {
            throw new QueryOperateException("query manager has Exception.", this.error.getException());
        }
        return this.resultSet;
    }

    public int getUpdateCount() throws QueryOperateException {
        if (this.hasError()) {
            throw new QueryOperateException("query manager has Exception.", this.error.getException());
        }
        return this.updateCount;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
        this.executed = false;
        this.updateCount = 0;
        this.resultSet = null;
        this.error = null;
    }

    public boolean isSelectQuery() {
        return this.query.trim().toLowerCase().startsWith("select");
    }

    public DatabaseError getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void execute() throws DatabaseSessionException, QueryOperateException {
        this.executed = false;
        this.updateCount = 0;
        this.resultSet = null;
        this.error = null;
        this.log.trace((Object)("execute query : \n" + this.query));
        if (this.isSelectQuery()) {
            this.executeSelectQuery();
        } else {
            this.executeUpdateQuery();
        }
        this.executed = true;
    }

    private void executeSelectQuery() throws DatabaseSessionException, QueryOperateException {
        try {
            Connection connection = this.session.getConnection();
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement(this.query, 1005, 1008);
            }
            catch (SQLException e1) {
                try {
                    statement = connection.prepareStatement(this.query, 1004, 1008);
                }
                catch (SQLException e2) {
                    try {
                        statement = connection.prepareStatement(this.query, 1003, 1008);
                    }
                    catch (SQLException e3) {
                        try {
                            statement = connection.prepareStatement(this.query, 1003, 1007);
                        }
                        catch (SQLException e4) {
                            try {
                                statement = connection.prepareStatement(this.query);
                            }
                            catch (SQLException e5) {
                                this.error = new DatabaseError(e5);
                                this.log.error((Object)"failed to create PreparedStatement object.", (Throwable)e5);
                            }
                        }
                    }
                }
            }
            if (statement == null) {
                throw new QueryOperateException("failed to create PreparedStatement object.");
            }
            this.resultSet = statement.executeQuery();
        }
        catch (SQLException e) {
            this.error = new DatabaseError(e);
            this.log.error((Object)"failed to execute select query.", (Throwable)e);
            this.session.rollback();
            this.session.close();
        }
    }

    private void executeUpdateQuery() throws DatabaseSessionException, QueryOperateException {
        try {
            Connection connection = this.session.getConnection();
            PreparedStatement statement = null;
            statement = connection.prepareStatement(this.query);
            if (statement == null) {
                throw new QueryOperateException("failed to create PreparedStatement object.");
            }
            this.updateCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            this.error = new DatabaseError(e);
            this.log.error((Object)"failed to execute update query.", (Throwable)e);
            this.session.rollback();
            this.session.close();
        }
    }
}

