/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.container;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.container.DatabaseSchemaHolder;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.database.container.DatabaseTableHolder;

public final class DatabaseSchema
implements Serializable,
DatabaseTableHolder {
    private DatabaseSchemaHolder schemaHolder = null;
    private String name = null;
    private List tableList = null;

    protected DatabaseSchema(String name) {
        this.name = name;
        this.tableList = new LinkedList();
    }

    private DatabaseSchema() {
        this(null);
    }

    public String getName() {
        return this.name;
    }

    public Iterator getTableListIterator() {
        return this.tableList.iterator();
    }

    public int getTableListCount() {
        return this.tableList.size();
    }

    public DatabaseTable getTable(String name) {
        String key = name == null ? "" : name;
        Iterator iterator = this.tableList.iterator();
        while (iterator.hasNext()) {
            DatabaseTable table = (DatabaseTable)iterator.next();
            if (!key.equals(table.getName())) continue;
            return table;
        }
        return null;
    }

    protected void setSchemaHolder(DatabaseSchemaHolder schemaHolder) {
        this.schemaHolder = schemaHolder;
    }

    public DatabaseSchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    protected void addTable(DatabaseTable table) {
        this.tableList.add(table);
    }
}

