/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.common.window;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EButton;
import org.phosphoresce.commons.eswing.EDialog;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETextArea;
import org.phosphoresce.dbbrowser.DatabaseBrowserImages;

public final class MessageDialog
extends EDialog {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final int BUTTON_CLOSE = -1;
    public static final int BUTTON_CANCEL = 0;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_YES = 2;
    public static final int BUTTON_NO = 3;
    public static final int BUTTON_RETRY = 4;
    private int pressedButton = -1;
    private EPanel contentsPanel = null;
    private ELabel dialogIconLabel = null;
    private ELabel messageLabel = null;
    private EPanel messageContentsPanel = null;
    private EPanel buttonPanel = null;
    private boolean okButtonVisible = true;
    private EButton okButton = null;
    private boolean retryButtonVisible = true;
    private EButton retryButton = null;
    private boolean cancelButtonVisible = true;
    private EButton cancelButton = null;
    private boolean yesButtonVisible = true;
    private EButton yesButton = null;
    private boolean noButtonVisible = true;
    private EButton noButton = null;
    private boolean detailButtonVisible = true;
    private EButton detailButton = null;
    private EScrollPane detailMessageScrollPane = null;
    private ETextArea detailMessageField = null;

    private MessageDialog() {
        this.initialize();
    }

    private MessageDialog(Frame parent, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, boolean detailButtonVisible) {
        super(parent, true);
        this.retryButtonVisible = retryButtonVisible;
        this.okButtonVisible = okButtonVisible;
        this.cancelButtonVisible = cancelButtonVisible;
        this.yesButtonVisible = yesButtonVisible;
        this.noButtonVisible = noButtonVisible;
        this.detailButtonVisible = detailButtonVisible;
        this.initialize();
    }

    private MessageDialog(Dialog parent, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, boolean detailButtonVisible) {
        super(parent, true);
        this.retryButtonVisible = retryButtonVisible;
        this.okButtonVisible = okButtonVisible;
        this.cancelButtonVisible = cancelButtonVisible;
        this.yesButtonVisible = yesButtonVisible;
        this.noButtonVisible = noButtonVisible;
        this.detailButtonVisible = detailButtonVisible;
        this.initialize();
    }

    public static int showError(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_ERROR));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showError(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_ERROR));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showError(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showError(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showError(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showError(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showError(Frame parent, String message) {
        return MessageDialog.showError(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showError(Dialog parent, String message) {
        return MessageDialog.showError(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showError(Frame parent, String message, Throwable throwable) {
        return MessageDialog.showError(parent, message, false, true, false, false, false, throwable);
    }

    public static int showError(Dialog parent, String message, Throwable throwable) {
        return MessageDialog.showError(parent, message, false, true, false, false, false, throwable);
    }

    public static int showError(Frame parent, String message, String detail) {
        return MessageDialog.showError(parent, message, false, true, false, false, false, detail);
    }

    public static int showError(Dialog parent, String message, String detail) {
        return MessageDialog.showError(parent, message, false, true, false, false, false, detail);
    }

    public static int showInformation(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_INFO));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showInformation(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_INFO));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showInformation(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showInformation(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showInformation(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showInformation(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showInformation(Frame parent, String message) {
        return MessageDialog.showInformation(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showInformation(Dialog parent, String message) {
        return MessageDialog.showInformation(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showInformation(Frame parent, String message, Throwable throwable) {
        return MessageDialog.showInformation(parent, message, false, true, false, false, false, throwable);
    }

    public static int showInformation(Dialog parent, String message, Throwable throwable) {
        return MessageDialog.showInformation(parent, message, false, true, false, false, false, throwable);
    }

    public static int showInformation(Frame parent, String message, String detail) {
        return MessageDialog.showInformation(parent, message, false, true, false, false, false, detail);
    }

    public static int showInformation(Dialog parent, String message, String detail) {
        return MessageDialog.showInformation(parent, message, false, true, false, false, false, detail);
    }

    public static int showWarning(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_WARN));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showWarning(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_WARN));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showWarning(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showWarning(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showWarning(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showWarning(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showWarning(Frame parent, String message) {
        return MessageDialog.showWarning(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showWarning(Dialog parent, String message) {
        return MessageDialog.showWarning(parent, message, false, true, false, false, false, (String)null);
    }

    public static int showWarning(Frame parent, String message, Throwable throwable) {
        return MessageDialog.showWarning(parent, message, false, true, false, false, false, throwable);
    }

    public static int showWarning(Dialog parent, String message, Throwable throwable) {
        return MessageDialog.showWarning(parent, message, false, true, false, false, false, throwable);
    }

    public static int showWarning(Frame parent, String message, String detail) {
        return MessageDialog.showWarning(parent, message, false, true, false, false, false, detail);
    }

    public static int showWarning(Dialog parent, String message, String detail) {
        return MessageDialog.showWarning(parent, message, false, true, false, false, false, detail);
    }

    public static int showQuestion(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_QUESTION));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showQuestion(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, String detail) {
        MessageDialog dialog = new MessageDialog(parent, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, detail != null && !"".equals(detail.trim()));
        dialog.getDialogIconLabel().setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_QUESTION));
        dialog.getDetailMessageField().setText(detail);
        dialog.setMessage(message);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.pressedButton;
    }

    public static int showQuestion(Frame parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showQuestion(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showQuestion(Dialog parent, String message, boolean retryButtonVisible, boolean okButtonVisible, boolean cancelButtonVisible, boolean yesButtonVisible, boolean noButtonVisible, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return MessageDialog.showQuestion(parent, message, retryButtonVisible, okButtonVisible, cancelButtonVisible, yesButtonVisible, noButtonVisible, writer.toString());
    }

    public static int showQuestion(Frame parent, String message) {
        return MessageDialog.showQuestion(parent, message, false, false, false, true, true, (String)null);
    }

    public static int showQuestion(Dialog parent, String message) {
        return MessageDialog.showQuestion(parent, message, false, false, false, true, true, (String)null);
    }

    public static int showQuestion(Frame parent, String message, Throwable throwable) {
        return MessageDialog.showQuestion(parent, message, false, false, false, true, true, throwable);
    }

    public static int showQuestion(Dialog parent, String message, Throwable throwable) {
        return MessageDialog.showQuestion(parent, message, false, false, false, true, true, throwable);
    }

    public static int showQuestion(Frame parent, String message, String detail) {
        return MessageDialog.showQuestion(parent, message, false, false, false, true, true, detail);
    }

    public static int showQuestion(Dialog parent, String message, String detail) {
        return MessageDialog.showQuestion(parent, message, false, false, false, true, true, detail);
    }

    public void setMessage(String message) {
        this.getMessageLabel().setText("<html>" + (message == null ? "" : message) + "</html>");
    }

    public String getMessage() {
        return this.getMessageLabel().getText().startsWith("<html>") && this.getMessageLabel().getText().endsWith("</html>") ? this.getMessageLabel().getText().substring(6, this.getMessageLabel().getText().length() - 7) : this.getMessageLabel().getText();
    }

    private void initialize() {
        this.setSize(new Dimension(596, 207));
        this.setContentPane((Container)this.getContentsPanel());
        this.setTitle("Database Browser");
    }

    private EPanel getContentsPanel() {
        if (this.contentsPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.0;
            this.contentsPanel = new EPanel();
            this.contentsPanel.setLayout((LayoutManager)new GridBagLayout());
            this.contentsPanel.add((Component)this.getMessageContentsPanel(), (Object)gridBagConstraints1);
            this.contentsPanel.add((Component)this.getDetailMessageScrollPane(), (Object)gridBagConstraints2);
            this.contentsPanel.add((Component)this.getButtonPanel(), (Object)gridBagConstraints3);
        }
        return this.contentsPanel;
    }

    private ELabel getDialogIconLabel() {
        if (this.dialogIconLabel == null) {
            this.dialogIconLabel = new ELabel();
            this.dialogIconLabel.setPreferredSize(new Dimension(32, 32));
            this.dialogIconLabel.setHorizontalAlignment(0);
            this.dialogIconLabel.setVerticalAlignment(1);
            this.dialogIconLabel.setIcon((Icon)new ImageIcon(DatabaseBrowserImages.IMAGE_DIALOG_ICON_INFO));
        }
        return this.dialogIconLabel;
    }

    private ELabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new ELabel();
            this.messageLabel.setVerticalAlignment(1);
            this.messageLabel.setPreferredSize(new Dimension(400, 80));
        }
        return this.messageLabel;
    }

    private EPanel getMessageContentsPanel() {
        if (this.messageContentsPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.anchor = 11;
            gridBagConstraints1.insets = new Insets(30, 20, 10, 10);
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.weighty = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.insets = new Insets(20, 10, 20, 20);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            this.messageContentsPanel = new EPanel();
            this.messageContentsPanel.setLayout((LayoutManager)new GridBagLayout());
            this.messageContentsPanel.add((Component)this.getDialogIconLabel(), (Object)gridBagConstraints1);
            this.messageContentsPanel.add((Component)this.getMessageLabel(), (Object)gridBagConstraints2);
        }
        return this.messageContentsPanel;
    }

    private EPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints;
            this.buttonPanel = new EPanel();
            this.buttonPanel.setLayout((LayoutManager)new GridBagLayout());
            this.buttonPanel.setPreferredSize(new Dimension(470, 44));
            if (this.retryButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getRetryButton(), (Object)gridBagConstraints);
            }
            if (this.yesButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getYesButton(), (Object)gridBagConstraints);
            }
            if (this.noButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getNoButton(), (Object)gridBagConstraints);
            }
            if (this.okButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getOkButton(), (Object)gridBagConstraints);
            }
            if (this.cancelButtonVisible) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 0;
                this.buttonPanel.add((Component)this.getCancelButton(), (Object)gridBagConstraints);
            }
            if (this.detailButtonVisible) {
                GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
                gridBagConstraints6.insets = new Insets(0, 4, 0, 4);
                gridBagConstraints6.gridx = 5;
                gridBagConstraints6.gridy = 0;
                this.buttonPanel.add((Component)this.getDetailButton(), (Object)gridBagConstraints6);
            }
        }
        return this.buttonPanel;
    }

    private EButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new EButton();
            this.okButton.setText("OK");
            this.okButton.setPreferredSize(new Dimension(86, 24));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.pressedButton = 1;
                    MessageDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private EButton getRetryButton() {
        if (this.retryButton == null) {
            this.retryButton = new EButton();
            this.retryButton.setPreferredSize(new Dimension(86, 24));
            this.retryButton.setText("Retry");
            this.retryButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.pressedButton = 4;
                    MessageDialog.this.dispose();
                }
            });
        }
        return this.retryButton;
    }

    private EButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new EButton();
            this.cancelButton.setPreferredSize(new Dimension(86, 24));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.pressedButton = 0;
                    MessageDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private EButton getYesButton() {
        if (this.yesButton == null) {
            this.yesButton = new EButton();
            this.yesButton.setPreferredSize(new Dimension(86, 24));
            this.yesButton.setText("Yes");
            this.yesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.pressedButton = 2;
                    MessageDialog.this.dispose();
                }
            });
        }
        return this.yesButton;
    }

    private EButton getNoButton() {
        if (this.noButton == null) {
            this.noButton = new EButton();
            this.noButton.setPreferredSize(new Dimension(86, 24));
            this.noButton.setText("No");
            this.noButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.pressedButton = 3;
                    MessageDialog.this.dispose();
                }
            });
        }
        return this.noButton;
    }

    private EButton getDetailButton() {
        if (this.detailButton == null) {
            this.detailButton = new EButton();
            this.detailButton.setPreferredSize(new Dimension(86, 24));
            this.detailButton.setText("Detail >>");
            this.detailButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Dimension dimension = MessageDialog.this.getSize();
                    if (!MessageDialog.this.getDetailMessageScrollPane().isVisible()) {
                        dimension.height += ((MessageDialog)MessageDialog.this).getDetailMessageScrollPane().getPreferredSize().height;
                        MessageDialog.this.setSize(dimension);
                        MessageDialog.this.getDetailMessageScrollPane().setVisible(true);
                        MessageDialog.this.getDetailButton().setText("<< Detail");
                        MessageDialog.this.pack();
                    } else {
                        dimension.height -= ((MessageDialog)MessageDialog.this).getDetailMessageScrollPane().getPreferredSize().height;
                        MessageDialog.this.setSize(dimension);
                        MessageDialog.this.getDetailMessageScrollPane().setVisible(false);
                        MessageDialog.this.getDetailButton().setText("Detail >>");
                        MessageDialog.this.pack();
                    }
                }
            });
        }
        return this.detailButton;
    }

    private EScrollPane getDetailMessageScrollPane() {
        if (this.detailMessageScrollPane == null) {
            this.detailMessageScrollPane = new EScrollPane();
            this.detailMessageScrollPane.setSize(new Dimension(400, 240));
            this.detailMessageScrollPane.setPreferredSize(new Dimension(400, 240));
            this.detailMessageScrollPane.setVisible(false);
            this.detailMessageScrollPane.setViewportView((Component)this.getDetailMessageField());
        }
        return this.detailMessageScrollPane;
    }

    private ETextArea getDetailMessageField() {
        if (this.detailMessageField == null) {
            this.detailMessageField = new ETextArea();
            this.detailMessageField.setEditable(false);
        }
        return this.detailMessageField;
    }
}

